/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.CostAdjuster;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.hint.common.MonstrousHint;
import mage.abilities.keyword.BecomeMonstrousSourceEffect;
import mage.constants.Zone;

public class MonstrosityAbility
extends ActivatedAbilityImpl {
    private final DynamicValue monstrosityValue;

    public MonstrosityAbility(String manaString, int monstrosityValue) {
        this(manaString, monstrosityValue, null, "");
    }

    public MonstrosityAbility(String manaString, int monstrosityValue, CostAdjuster costAdjuster, String costAdjusterText) {
        this(manaString, StaticValue.get(monstrosityValue), costAdjuster, costAdjusterText);
    }

    public MonstrosityAbility(String manaString, DynamicValue monstrosityValue, CostAdjuster costAdjuster, String costAdjusterText) {
        super(Zone.BATTLEFIELD, new BecomeMonstrousSourceEffect(monstrosityValue, costAdjusterText), new ManaCostsImpl(manaString));
        this.monstrosityValue = monstrosityValue;
        this.addHint(MonstrousHint.instance);
        this.setCostAdjuster(costAdjuster);
    }

    protected MonstrosityAbility(MonstrosityAbility ability) {
        super(ability);
        this.monstrosityValue = ability.monstrosityValue;
    }

    @Override
    public MonstrosityAbility copy() {
        return new MonstrosityAbility(this);
    }

    public DynamicValue getMonstrosityValue() {
        return this.monstrosityValue;
    }
}

