/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.SpellAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.common.continuous.BecomesFaceDownCreatureEffect;
import mage.cards.Card;
import mage.constants.SpellAbilityCastMode;
import mage.constants.SpellAbilityType;
import mage.constants.TimingRule;

public class MorphAbility
extends SpellAbility {
    protected static final String ABILITY_KEYWORD = "Morph";
    protected static final String REMINDER_TEXT = "You may cast this card face down as a 2/2 creature for {3}. Turn it face up any time for its morph cost.";
    protected static final String ABILITY_KEYWORD_MEGA = "Megamorph";
    protected static final String REMINDER_TEXT_MEGA = "You may cast this card face down as a 2/2 creature for {3}. Turn it face up any time for its megamorph cost and put a +1/+1 counter on it.";
    protected Costs<Cost> morphCosts;
    protected boolean isMegamorph;

    public MorphAbility(Card card, Cost morphCost) {
        this(card, morphCost, false);
    }

    public MorphAbility(Card card, Cost morphCost, boolean useMegamorph) {
        super(new GenericManaCost(3), card.getName());
        this.timing = TimingRule.SORCERY;
        this.morphCosts = new CostsImpl<Cost>();
        this.morphCosts.add(morphCost);
        this.isMegamorph = useMegamorph;
        this.setSpellAbilityCastMode(SpellAbilityCastMode.MORPH);
        this.setSpellAbilityType(SpellAbilityType.BASE_ALTERNATE);
        SimpleStaticAbility ability = new SimpleStaticAbility(new BecomesFaceDownCreatureEffect(this.morphCosts, useMegamorph ? BecomesFaceDownCreatureEffect.FaceDownType.MEGAMORPHED : BecomesFaceDownCreatureEffect.FaceDownType.MORPHED));
        ability.setWorksFaceDown(true);
        ability.setRuleVisible(false);
        this.addSubAbility(ability);
    }

    protected MorphAbility(MorphAbility ability) {
        super(ability);
        this.morphCosts = ability.morphCosts;
        this.isMegamorph = ability.isMegamorph;
    }

    @Override
    public MorphAbility copy() {
        return new MorphAbility(this);
    }

    public Costs<Cost> getFaceUpCosts() {
        return this.morphCosts;
    }

    @Override
    public String getRule() {
        String reminder;
        String text;
        boolean isMana = this.morphCosts.get(0) instanceof ManaCost;
        if (this.isMegamorph) {
            text = ABILITY_KEYWORD_MEGA;
            reminder = REMINDER_TEXT_MEGA;
        } else {
            text = ABILITY_KEYWORD;
            reminder = REMINDER_TEXT;
        }
        return text + (isMana ? " " : "&mdash;") + this.morphCosts.getText() + (isMana ? Character.valueOf(' ') : ". ") + " <i>(" + reminder + ")</i>";
    }
}

