/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.FixedTargets;
import org.apache.log4j.Logger;

class MyriadEffect
extends OneShotEffect {
    public MyriadEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each opponent other than the defending player, you may put a token that's a copy of this creature onto the battlefield tapped and attacking that player or a planeswalker they control. Exile the tokens at the end of combat";
    }

    protected MyriadEffect(MyriadEffect effect) {
        super(effect);
    }

    @Override
    public MyriadEffect copy() {
        return new MyriadEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourceObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourceObject != null) {
            UUID defendingPlayerId = game.getCombat().getDefendingPlayerId(source.getSourceId(), game);
            if (defendingPlayerId == null) {
                Logger.getLogger(MyriadEffect.class).error((Object)("defending player == null source: " + sourceObject.getName() + " attacking: " + (sourceObject.isAttacking() ? "Y" : "N")));
                return false;
            }
            ArrayList<Permanent> tokens = new ArrayList<Permanent>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player opponent;
                if (playerId.equals(defendingPlayerId) || !controller.hasOpponent(playerId, game) || (opponent = game.getPlayer(playerId)) == null || !controller.chooseUse(Outcome.PutCreatureInPlay, "Put a copy of " + sourceObject.getIdName() + " onto battlefield attacking " + opponent.getName() + '?', source, game)) continue;
                CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(controller.getId(), null, false, 1, true, true, playerId);
                effect.setTargetPointer(new FixedTarget(sourceObject, game));
                effect.apply(game, source);
                tokens.addAll(effect.getAddedPermanents());
            }
            if (!tokens.isEmpty()) {
                ExileTargetEffect exileEffect = new ExileTargetEffect();
                exileEffect.setTargetPointer(new FixedTargets(new ArrayList(tokens), game));
                game.addDelayedTriggeredAbility(new AtTheEndOfCombatDelayedTriggeredAbility(exileEffect), source);
            }
            return true;
        }
        return false;
    }
}

