/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.NinjutsuEffect;
import mage.abilities.keyword.ReturnAttackerToHandTargetCost;
import mage.abilities.keyword.RevealNinjutsuCardCost;
import mage.constants.Zone;

public class NinjutsuAbility
extends ActivatedAbilityImpl {
    private final boolean commander;

    public NinjutsuAbility(String manaString) {
        this(new ManaCostsImpl(manaString), false);
    }

    public NinjutsuAbility(Cost cost, boolean commander) {
        super(commander ? Zone.ALL : Zone.HAND, new NinjutsuEffect(commander), cost);
        this.addCost(new RevealNinjutsuCardCost(commander));
        this.addCost(new ReturnAttackerToHandTargetCost());
        this.commander = commander;
    }

    private NinjutsuAbility(NinjutsuAbility ability) {
        super(ability);
        this.commander = ability.commander;
    }

    @Override
    public NinjutsuAbility copy() {
        return new NinjutsuAbility(this);
    }

    @Override
    public String getRule() {
        return (this.commander ? "Commander n" : "N") + "injutsu " + this.getManaCostsToPay().getText() + " <i>(" + this.getManaCostsToPay().getText() + " Return an unblocked attacker you control to hand: Put this card onto the battlefield from your hand" + (this.commander ? " or the command zone " : " ") + "tapped and attacking.)</i>";
    }
}

