/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.StaticAbility;
import mage.abilities.costs.mana.ActivationManaAbilityStep;
import mage.abilities.costs.mana.AlternateManaPaymentAbility;
import mage.abilities.costs.mana.HybridManaCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.keyword.OfferingAsThoughEffect;
import mage.abilities.mana.ManaOptions;
import mage.cards.Card;
import mage.constants.Zone;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.util.CardUtil;

public class OfferingAbility
extends StaticAbility
implements AlternateManaPaymentAbility {
    private final FilterControlledPermanent filter;

    public OfferingAbility(FilterControlledPermanent filter) {
        super(Zone.ALL, null);
        this.filter = filter;
        this.addEffect(new OfferingAsThoughEffect());
    }

    public OfferingAbility(OfferingAbility ability) {
        super(ability);
        this.filter = ability.filter;
    }

    @Override
    public OfferingAbility copy() {
        return new OfferingAbility(this);
    }

    public FilterControlledPermanent getFilter() {
        return this.filter;
    }

    @Override
    public String getRule(boolean all) {
        String message = this.filter.getMessage();
        return message + " offering <i>(You may cast this card any time you could cast an instant by sacrificing " + CardUtil.addArticle(message) + " and paying the difference in mana costs between this and the sacrificed " + message + ". Mana cost includes color.)</i>";
    }

    @Override
    public ActivationManaAbilityStep useOnActivationManaAbilityStep() {
        return ActivationManaAbilityStep.NORMAL;
    }

    @Override
    public void addSpecialAction(Ability source, Game game, ManaCost unpaid) {
    }

    @Override
    public ManaOptions getManaOptions(Ability source, Game game, ManaCost unpaid) {
        ManaOptions additionalManaOptionsForThisAbility = new ManaOptions();
        game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game).stream().map(Card::getSpellAbility).filter(Objects::nonNull).forEach(spellAbility -> {
            ManaOptions manaOptionsForThisPermanent = new ManaOptions();
            for (ManaCost manaCost : spellAbility.getManaCosts()) {
                if (manaCost instanceof HybridManaCost) {
                    ManaOptions manaOptionsForHybrid = new ManaOptions();
                    manaOptionsForHybrid.addAll(manaCost.getManaOptions());
                    manaOptionsForThisPermanent.addMana(manaOptionsForHybrid);
                    continue;
                }
                manaOptionsForThisPermanent.addMana(manaCost.getMana());
            }
            additionalManaOptionsForThisAbility.addAll(manaOptionsForThisPermanent);
        });
        additionalManaOptionsForThisAbility.removeFullyIncludedVariations();
        return additionalManaOptionsForThisAbility;
    }
}

