/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.keyword.OfferingAbility;
import mage.abilities.keyword.OfferingCostReductionEffect;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetSacrifice;
import mage.target.targetpointer.FixedTarget;
import mage.util.GameLog;

class OfferingAsThoughEffect
extends AsThoughEffectImpl {
    public OfferingAsThoughEffect() {
        super(AsThoughEffectType.CAST_AS_INSTANT, Duration.EndOfGame, Outcome.Benefit);
    }

    protected OfferingAsThoughEffect(OfferingAsThoughEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return true;
    }

    @Override
    public OfferingAsThoughEffect copy() {
        return new OfferingAsThoughEffect(this);
    }

    @Override
    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        return false;
    }

    @Override
    public boolean applies(UUID sourceId, Ability affectedAbility, Ability source, Game game, UUID playerId) {
        if (sourceId.equals(source.getSourceId())) {
            Card card = game.getCard(sourceId);
            if (card == null || !card.isOwnedBy(source.getControllerId())) {
                return false;
            }
            Object object = game.getState().getValue("offering_" + card.getId());
            if (object != null && object.equals(true)) {
                Object alreadyConfirmed = game.getState().getValue("offering_ok_" + card.getId());
                game.getState().setValue("offering_" + card.getId(), null);
                game.getState().setValue("offering_ok_" + card.getId(), null);
                return alreadyConfirmed != null;
            }
            game.getState().setValue("offering_Id_" + card.getId(), null);
            if (game.getBattlefield().count(((OfferingAbility)source).getFilter(), source.getControllerId(), source, game) > 0) {
                if (game.inCheckPlayableState()) {
                    return true;
                }
                FilterControlledPermanent filter = ((OfferingAbility)source).getFilter();
                Card spellToCast = game.getCard(source.getSourceId());
                if (spellToCast == null) {
                    return false;
                }
                Player player = game.getPlayer(source.getControllerId());
                if (player != null && player.chooseUse(Outcome.Benefit, "Offer a " + filter.getMessage() + " to cast " + spellToCast.getName() + '?', source, game)) {
                    TargetSacrifice target = new TargetSacrifice(filter);
                    player.choose(Outcome.Sacrifice, target, source, game);
                    if (!target.isChosen(game)) {
                        return false;
                    }
                    game.getState().setValue("offering_" + card.getId(), true);
                    Permanent offer = game.getPermanent(target.getFirstTarget());
                    if (offer != null) {
                        UUID activationId = UUID.randomUUID();
                        OfferingCostReductionEffect effect = new OfferingCostReductionEffect(activationId);
                        effect.setTargetPointer(new FixedTarget(offer, game));
                        game.addEffect(effect, source);
                        game.getState().setValue("offering_ok_" + card.getId(), true);
                        game.getState().setValue("offering_Id_" + card.getId(), activationId);
                        game.informPlayers(player.getLogName() + " announces to offer " + offer.getLogName() + " to cast " + GameLog.getColoredObjectName(spellToCast));
                        return true;
                    }
                } else {
                    game.getState().setValue("offering_" + card.getId(), true);
                }
            }
        }
        return false;
    }
}

