/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class OfferingCostReductionEffect
extends CostModificationEffectImpl {
    private final UUID activationId;

    OfferingCostReductionEffect(UUID activationId) {
        super(Duration.OneUse, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.activationId = activationId;
        this.staticText = "mana costs reduction from offering";
    }

    OfferingCostReductionEffect(OfferingCostReductionEffect effect) {
        super(effect);
        this.activationId = effect.activationId;
    }

    @Override
    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Permanent toOffer = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (toOffer != null) {
            toOffer.sacrifice(source, game);
            if (toOffer.getSpellAbility() != null) {
                CardUtil.reduceCost((SpellAbility)abilityToModify, toOffer.getSpellAbility().getManaCosts());
            }
        }
        game.getState().setValue("offering_" + source.getSourceId(), null);
        game.getState().setValue("offering_ok_" + source.getSourceId(), null);
        this.discard();
        return true;
    }

    @Override
    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (game.inCheckPlayableState()) {
            return false;
        }
        if (abilityToModify.getSourceId().equals(source.getSourceId()) && abilityToModify instanceof SpellAbility) {
            Object object;
            Card card = game.getCard(source.getSourceId());
            if (card != null && (object = game.getState().getValue("offering_Id_" + card.getId())) != null && object.equals(this.activationId) && this.getTargetPointer().getFirst(game, source) != null) {
                return true;
            }
            this.discard();
        }
        return false;
    }

    @Override
    public OfferingCostReductionEffect copy() {
        return new OfferingCostReductionEffect(this);
    }
}

