/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpecialAction;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.PlotAddSpellAbilityEffect;
import mage.abilities.keyword.PlotSourceExileEffect;
import mage.cards.Card;
import mage.constants.TimingRule;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.CardUtil;

public class PlotAbility
extends SpecialAction {
    private final String rule;

    public PlotAbility(String plotCost) {
        super(Zone.ALL);
        this.addCost(new ManaCostsImpl(plotCost));
        this.addEffect(new PlotSourceExileEffect());
        this.setTiming(TimingRule.SORCERY);
        this.usesStack = false;
        this.rule = "Plot " + plotCost;
    }

    private PlotAbility(PlotAbility ability) {
        super(ability);
        this.rule = ability.rule;
    }

    @Override
    public PlotAbility copy() {
        return new PlotAbility(this);
    }

    @Override
    public String getRule() {
        return this.rule;
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Set<MageIdentifier> allowedToBeCastNow;
        Card card = game.getCard(this.getSourceId());
        if (card == null) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        Zone zone = game.getState().getZone(this.getSourceId());
        if (zone != Zone.HAND) {
            if (zone == Zone.LIBRARY) {
                Player player = game.getPlayer(this.getControllerId());
                if (player == null || !player.canPlotFromTopOfLibrary()) {
                    return ActivatedAbility.ActivationStatus.getFalse();
                }
                Card topCardLibrary = player.getLibrary().getFromTop(game);
                if (topCardLibrary == null || !topCardLibrary.getId().equals(card.getId()) || card.isLand()) {
                    return ActivatedAbility.ActivationStatus.getFalse();
                }
            } else {
                return ActivatedAbility.ActivationStatus.getFalse();
            }
        }
        if (!(allowedToBeCastNow = card.getSpellAbility().spellCanBeActivatedNow(playerId, game)).contains((Object)MageIdentifier.Default) && !allowedToBeCastNow.contains((Object)card.getSpellAbility().getIdentifier())) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        return super.canActivate(playerId, game);
    }

    static UUID getPlotExileId(UUID playerId, Game game) {
        UUID exileId = (UUID)game.getState().getValue("PlotExileId" + playerId.toString());
        if (exileId == null) {
            exileId = UUID.randomUUID();
            game.getState().setValue("PlotExileId" + playerId, exileId);
        }
        return exileId;
    }

    static String getPlotTurnKeyForCard(UUID cardId) {
        return cardId.toString() + "|Plotted Turn";
    }

    public static boolean doExileAndPlotCard(Card card, Game game, Ability source) {
        if (card == null) {
            return false;
        }
        Player owner = game.getPlayer(card.getOwnerId());
        if (owner == null) {
            return false;
        }
        UUID exileId = PlotAbility.getPlotExileId(owner.getId(), game);
        String exileZoneName = "Plots of " + owner.getName();
        Card mainCard = card.getMainCard();
        Zone zone = game.getState().getZone(mainCard.getId());
        if (mainCard.moveToExile(exileId, exileZoneName, source, game)) {
            game.getState().setValue(PlotAbility.getPlotTurnKeyForCard(mainCard.getId()), game.getTurnNum());
            game.addEffect(new PlotAddSpellAbilityEffect(new MageObjectReference(mainCard, game)), source);
            game.informPlayers(owner.getLogName() + " plots " + mainCard.getLogName() + " from " + zone.toString().toLowerCase() + CardUtil.getSourceLogName(game, source, card.getId()));
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.BECOME_PLOTTED, mainCard.getId(), source, owner.getId()));
        }
        return true;
    }
}

