/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.PlotAbility;
import mage.cards.Card;
import mage.cards.CardWithHalves;
import mage.cards.CardWithSpellOption;
import mage.constants.SpellAbilityCastMode;
import mage.constants.SpellAbilityType;
import mage.constants.Zone;
import mage.game.Game;

class PlotSpellAbility
extends SpellAbility {
    private String faceCardName;
    private SpellAbility spellAbilityToResolve;

    PlotSpellAbility(String faceCardName) {
        super(null, faceCardName, Zone.EXILED, SpellAbilityType.BASE_ALTERNATE, SpellAbilityCastMode.PLOT);
        this.setRuleVisible(false);
        this.setAdditionalCostsRuleVisible(false);
        this.faceCardName = faceCardName;
        this.addCost(new ManaCostsImpl("{0}"));
    }

    private PlotSpellAbility(PlotSpellAbility ability) {
        super(ability);
        this.faceCardName = ability.faceCardName;
        this.spellAbilityToResolve = ability.spellAbilityToResolve;
    }

    @Override
    public PlotSpellAbility copy() {
        return new PlotSpellAbility(this);
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Card card;
        if (super.canActivate(playerId, game).canActivate() && (card = game.getCard(this.getSourceId())) != null) {
            Card mainCard = card.getMainCard();
            UUID mainCardId = mainCard.getId();
            if (game.getState().getZone(mainCardId) != Zone.EXILED) {
                return ActivatedAbility.ActivationStatus.getFalse();
            }
            Integer plottedTurn = (Integer)game.getState().getValue(PlotAbility.getPlotTurnKeyForCard(mainCardId));
            if (plottedTurn == null) {
                return ActivatedAbility.ActivationStatus.getFalse();
            }
            if (plottedTurn.intValue() == game.getTurnNum()) {
                return ActivatedAbility.ActivationStatus.getFalse();
            }
            if (!game.canPlaySorcery(playerId)) {
                return ActivatedAbility.ActivationStatus.getFalse();
            }
            if (mainCard instanceof CardWithHalves) {
                if (((CardWithHalves)mainCard).getLeftHalfCard().getName().equals(this.faceCardName)) {
                    return ((CardWithHalves)mainCard).getLeftHalfCard().getSpellAbility().canActivate(playerId, game);
                }
                if (((CardWithHalves)mainCard).getRightHalfCard().getName().equals(this.faceCardName)) {
                    return ((CardWithHalves)mainCard).getRightHalfCard().getSpellAbility().canActivate(playerId, game);
                }
            } else if (card instanceof CardWithSpellOption) {
                if (card.getMainCard().getName().equals(this.faceCardName)) {
                    return card.getMainCard().getSpellAbility().canActivate(playerId, game);
                }
                if (((CardWithSpellOption)card).getSpellCard().getName().equals(this.faceCardName)) {
                    return ((CardWithSpellOption)card).getSpellCard().getSpellAbility().canActivate(playerId, game);
                }
            }
            return card.getSpellAbility().canActivate(playerId, game);
        }
        return ActivatedAbility.ActivationStatus.getFalse();
    }

    @Override
    public SpellAbility getSpellAbilityToResolve(Game game) {
        Card card = game.getCard(this.getSourceId());
        if (card != null && this.spellAbilityToResolve == null) {
            SpellAbility spellAbilityCopy = null;
            if (card instanceof CardWithHalves) {
                if (((CardWithHalves)card).getLeftHalfCard().getName().equals(this.faceCardName)) {
                    spellAbilityCopy = ((CardWithHalves)card).getLeftHalfCard().getSpellAbility().copy();
                } else if (((CardWithHalves)card).getRightHalfCard().getName().equals(this.faceCardName)) {
                    spellAbilityCopy = ((CardWithHalves)card).getRightHalfCard().getSpellAbility().copy();
                }
            } else if (card instanceof CardWithSpellOption) {
                if (card.getMainCard().getName().equals(this.faceCardName)) {
                    spellAbilityCopy = card.getMainCard().getSpellAbility().copy();
                } else if (((CardWithSpellOption)card).getSpellCard().getName().equals(this.faceCardName)) {
                    spellAbilityCopy = ((CardWithSpellOption)card).getSpellCard().getSpellAbility().copy();
                }
            } else {
                spellAbilityCopy = card.getSpellAbility().copy();
            }
            if (spellAbilityCopy == null) {
                return null;
            }
            spellAbilityCopy.setId(this.getId());
            spellAbilityCopy.clearManaCosts();
            spellAbilityCopy.clearManaCostsToPay();
            spellAbilityCopy.addCost(this.getCosts().copy());
            spellAbilityCopy.addCost(this.getManaCosts().copy());
            spellAbilityCopy.setSpellAbilityCastMode(this.getSpellAbilityCastMode());
            this.spellAbilityToResolve = spellAbilityCopy;
        }
        return this.spellAbilityToResolve;
    }

    @Override
    public Costs<Cost> getCosts() {
        if (this.spellAbilityToResolve == null) {
            return super.getCosts();
        }
        return this.spellAbilityToResolve.getCosts();
    }
}

