/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.SpellAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.PrototypeEffect;
import mage.cards.Card;
import mage.constants.SpellAbilityCastMode;
import mage.constants.TimingRule;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class PrototypeAbility
extends SpellAbility {
    private final int power;
    private final int toughness;
    private final String manaString;
    private final String rule;

    public PrototypeAbility(Card card, String manaString, int power, int toughness) {
        super(new ManaCostsImpl(manaString), card.getName());
        this.setSpellAbilityCastMode(SpellAbilityCastMode.PROTOTYPE);
        this.setTiming(TimingRule.SORCERY);
        this.addSubAbility(new SimpleStaticAbility(new PrototypeEffect(power, toughness, manaString)).setRuleVisible(false));
        this.rule = "Prototype " + manaString + " &mdash; " + power + "/" + toughness + " <i>(You may cast this spell with different mana cost, color, and size. It keeps its abilities and types.)</i>";
        this.setRuleAtTheTop(true);
        this.power = power;
        this.toughness = toughness;
        this.manaString = manaString;
    }

    private PrototypeAbility(PrototypeAbility ability) {
        super(ability);
        this.rule = ability.rule;
        this.power = ability.power;
        this.toughness = ability.toughness;
        this.manaString = ability.manaString;
    }

    @Override
    public PrototypeAbility copy() {
        return new PrototypeAbility(this);
    }

    @Override
    public String getRule() {
        return this.rule;
    }

    public Card prototypeCardSpell(Card original) {
        Card newCard = original.copy();
        newCard.setManaCost(new ManaCostsImpl<ManaCost>(this.manaString));
        newCard.getPower().setModifiedBaseValue(this.power);
        newCard.getToughness().setModifiedBaseValue(this.toughness);
        newCard.getColor().setColor(new ObjectColor(this.manaString));
        return newCard;
    }

    public void prototypePermanent(MageObject targetObject, Game game) {
        if (targetObject instanceof Permanent) {
            ((Permanent)targetObject).setPrototyped(true);
        }
        targetObject.getColor(game).setColor(new ObjectColor(this.manaString));
        targetObject.setManaCost(new ManaCostsImpl<ManaCost>(this.manaString));
        targetObject.getPower().setModifiedBaseValue(this.power);
        targetObject.getToughness().setModifiedBaseValue(this.toughness);
    }
}

