/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ReboundCastSpellFromExileEffect
extends OneShotEffect {
    ReboundCastSpellFromExileEffect() {
        super(Outcome.PlayForFree);
    }

    private ReboundCastSpellFromExileEffect(ReboundCastSpellFromExileEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card reboundCard = game.getCard(this.getTargetPointer().getFirst(game, source));
        return player != null && reboundCard != null && CardUtil.castSpellWithAttributesForFree(player, source, game, new CardsImpl(reboundCard), StaticFilters.FILTER_CARD);
    }

    @Override
    public ReboundCastSpellFromExileEffect copy() {
        return new ReboundCastSpellFromExileEffect(this);
    }
}

