/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.keyword.ReconfigureTypeEffect;
import mage.abilities.keyword.ReconfigureUnattachAbility;
import mage.constants.Outcome;
import mage.constants.TimingRule;
import mage.constants.Zone;
import mage.target.common.TargetControlledCreaturePermanent;

public class ReconfigureAbility
extends ActivatedAbilityImpl {
    private final Cost cost;

    public ReconfigureAbility(String manaString) {
        this(new ManaCostsImpl(manaString));
    }

    public ReconfigureAbility(Cost cost) {
        super(Zone.BATTLEFIELD, new AttachEffect(Outcome.BoostCreature), cost);
        this.cost = cost;
        this.timing = TimingRule.SORCERY;
        this.addTarget(new TargetControlledCreaturePermanent());
        this.addSubAbility(new ReconfigureUnattachAbility(cost));
        SimpleStaticAbility ability = new SimpleStaticAbility(new ReconfigureTypeEffect());
        ability.setRuleVisible(false);
        this.addSubAbility(ability);
    }

    private ReconfigureAbility(ReconfigureAbility ability) {
        super(ability);
        this.cost = ability.cost;
    }

    @Override
    public ReconfigureAbility copy() {
        return new ReconfigureAbility(this);
    }

    @Override
    public String getRule() {
        return "Reconfigure " + this.cost.getText() + " (" + this.cost.getText() + ": Attach to target creature you control; or unattach from a creature. Reconfigure only as a sorcery. While attached, this isn't a creature.)";
    }
}

