/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.ExileSourceEffect;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.cards.Card;

class RecoverEffect
extends DoIfCostPaid {
    public RecoverEffect(Cost cost, Card card) {
        super((Effect)new ReturnToHandSourceEffect(), new ExileSourceEffect(), cost);
        this.staticText = this.setText(cost, card.isCreature());
    }

    protected RecoverEffect(RecoverEffect effect) {
        super(effect);
    }

    @Override
    public RecoverEffect copy() {
        return new RecoverEffect(this);
    }

    private String setText(Cost cost, boolean creature) {
        StringBuilder sb = new StringBuilder();
        sb.append("Recover");
        if (cost instanceof ManaCost) {
            sb.append(' ').append(cost.getText()).append(' ');
        } else {
            sb.append("&mdash;").append(cost.getText()).append(". ");
        }
        sb.append("<i>(When ").append(creature ? "another" : "a").append(" creature is put into your graveyard from the battlefield, you may pay ");
        sb.append(cost.getText());
        sb.append(". If you do, return this card from your graveyard to your hand. Otherwise, exile this card.)</i>");
        return sb.toString();
    }
}

