/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.StaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.OptionalAdditionalCost;
import mage.abilities.costs.OptionalAdditionalCostImpl;
import mage.abilities.costs.OptionalAdditionalSourceCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.ReplicateTriggeredAbility;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

public class ReplicateAbility
extends StaticAbility
implements OptionalAdditionalSourceCosts {
    private static final String keywordText = "Replicate";
    private static final String reminderTextMana = "When you cast this spell, copy it for each time you paid its replicate cost. You may choose new targets for the copies.";
    protected OptionalAdditionalCost additionalCost;

    public ReplicateAbility(String manaString) {
        this(new ManaCostsImpl(manaString));
    }

    public ReplicateAbility(Cost cost) {
        super(Zone.STACK, null);
        this.additionalCost = new OptionalAdditionalCostImpl(keywordText, reminderTextMana, cost);
        this.additionalCost.setRepeatable(true);
        this.setRuleAtTheTop(true);
        this.addSubAbility(new ReplicateTriggeredAbility(this.getId()));
    }

    protected ReplicateAbility(ReplicateAbility ability) {
        super(ability);
        this.additionalCost = ability.additionalCost;
    }

    @Override
    public ReplicateAbility copy() {
        return new ReplicateAbility(this);
    }

    @Override
    public void addCost(Cost cost) {
        if (this.additionalCost != null) {
            ((Costs)((Object)this.additionalCost)).add(cost);
        }
    }

    @Override
    public boolean isActivated() {
        return this.additionalCost != null && this.additionalCost.isActivated();
    }

    public int getActivateCount() {
        return this.additionalCost == null ? 0 : this.additionalCost.getActivateCount();
    }

    public void resetReplicate() {
        if (this.additionalCost != null) {
            this.additionalCost.reset();
        }
    }

    @Override
    public void addOptionalAdditionalCosts(Ability ability, Game game) {
        if (!(ability instanceof SpellAbility)) {
            return;
        }
        Player player = game.getPlayer(ability.getControllerId());
        if (player == null) {
            return;
        }
        this.resetReplicate();
        boolean again = true;
        while (player.canRespond() && again) {
            String times = "";
            if (this.additionalCost.isRepeatable()) {
                int numActivations = this.additionalCost.getActivateCount();
                times = numActivations + 1 + (numActivations == 0 ? " time " : " times ");
            }
            String payPrompt = "Pay " + times + this.additionalCost.getText(false) + " ?";
            boolean canPay = this.additionalCost.canPay(ability, this, ability.getControllerId(), game);
            if (!canPay || !player.chooseUse(Outcome.AIDontUseIt, payPrompt, ability, game)) {
                again = false;
                continue;
            }
            this.additionalCost.activate();
            for (Cost cost : (Costs)((Object)this.additionalCost)) {
                if (cost instanceof ManaCostsImpl) {
                    ability.addManaCostsToPay((ManaCostsImpl)cost.copy());
                    continue;
                }
                ability.addCost(cost.copy());
            }
        }
    }

    @Override
    public String getRule() {
        return this.additionalCost == null ? "" : this.additionalCost.getText(false) + ' ' + this.additionalCost.getReminderText();
    }

    @Override
    public String getCastMessageSuffix() {
        return this.additionalCost == null ? "" : this.additionalCost.getCastSuffixMessage(0);
    }

    public String getReminderText() {
        return this.additionalCost == null ? "" : this.additionalCost.getReminderText();
    }
}

