/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.ReplicateAbility;
import mage.abilities.keyword.ReplicateCopyEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class ReplicateTriggeredAbility
extends TriggeredAbilityImpl {
    private UUID replicateId;

    public ReplicateTriggeredAbility(UUID replicateId) {
        super(Zone.STACK, new ReplicateCopyEffect());
        this.replicateId = replicateId;
        this.setRuleVisible(false);
    }

    private ReplicateTriggeredAbility(ReplicateTriggeredAbility ability) {
        super(ability);
        this.replicateId = ability.replicateId;
    }

    @Override
    public ReplicateTriggeredAbility copy() {
        return new ReplicateTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getSourceId().equals(this.sourceId)) {
            return false;
        }
        StackObject spell = game.getStack().getStackObject(this.sourceId);
        if (!(spell instanceof Spell)) {
            return false;
        }
        Card card = ((Spell)spell).getCard();
        if (card == null) {
            return false;
        }
        for (Ability ability : card.getAbilities(game)) {
            if (!(ability instanceof ReplicateAbility) || !ability.isActivated() || ability.getId() != this.replicateId) continue;
            for (Effect effect : this.getEffects()) {
                effect.setValue("ReplicateSpell", spell);
                effect.setValue("ReplicateCount", ((ReplicateAbility)ability).getActivateCount());
            }
            return true;
        }
        return false;
    }

    @Override
    public String getRule() {
        return "Replicate <i>(When you cast this spell, copy it for each time you paid its replicate cost. You may choose new targets for the copies.)</i>";
    }
}

