/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.keyword.RippleEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.util.CardUtil;

public class RippleAbility
extends TriggeredAbilityImpl {
    protected final int rippleNumber;

    public RippleAbility(int rippleNumber) {
        super(Zone.STACK, new RippleEffect(rippleNumber), false);
        this.rippleNumber = rippleNumber;
    }

    public RippleAbility(RippleAbility ability) {
        super(ability);
        this.rippleNumber = ability.rippleNumber;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        return spell != null && spell.getSourceId().equals(this.getSourceId());
    }

    @Override
    public RippleAbility copy() {
        return new RippleAbility(this);
    }

    @Override
    public String getRule() {
        return "ripple " + this.rippleNumber + " <i>(When you cast this spell, you may reveal the top " + CardUtil.numberToText(this.rippleNumber) + " cards of your library. You may cast any revealed cards with the same name as this spell without paying their mana costs. Put the rest on the bottom of your library.)</i>";
    }
}

