/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.ApprovingObject;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class RippleEffect
extends OneShotEffect {
    protected int rippleNumber;

    public RippleEffect(int rippleNumber) {
        super(Outcome.PlayForFree);
        this.rippleNumber = rippleNumber;
    }

    protected RippleEffect(RippleEffect effect) {
        super(effect);
        this.rippleNumber = effect.rippleNumber;
    }

    @Override
    public RippleEffect copy() {
        return new RippleEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (player != null) {
            if (!player.chooseUse(Outcome.Neutral, "Reveal " + this.rippleNumber + " cards from the top of your library?", source, game)) {
                return true;
            }
            CardsImpl cards = new CardsImpl();
            cards.addAllCards(player.getLibrary().getTopCards(game, this.rippleNumber));
            player.revealCards(sourceObject.getIdName(), (Cards)cards, game);
            String cardNameToRipple = sourceObject.getName();
            FilterCard sameNameFilter = new FilterCard("card(s) with the name: \"" + cardNameToRipple + "\" to cast without paying their mana cost");
            sameNameFilter.add(new NamePredicate(cardNameToRipple));
            TargetCard target1 = new TargetCard(Zone.LIBRARY, sameNameFilter);
            target1.setRequired(false);
            while (player.canRespond() && cards.count(sameNameFilter, game) > 0 && player.choose(Outcome.PlayForFree, cards, target1, source, game)) {
                Card card = cards.get(target1.getFirstTarget(), game);
                if (card != null) {
                    game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), Boolean.TRUE);
                    player.cast(player.chooseAbilityForCast(card, game, true), game, true, new ApprovingObject(source, game));
                    game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
                    cards.remove(card);
                }
                target1.clearChosen();
            }
            player.putCardsOnBottomOfLibrary(cards, game, source, true);
            return true;
        }
        return false;
    }
}

