/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.condition.common.SaddledCondition;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.abilities.keyword.SaddleCost;
import mage.abilities.keyword.SaddleEventEffect;
import mage.constants.TimingRule;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.SaddledMountWatcher;

public class SaddleAbility
extends SimpleActivatedAbility {
    private final int value;
    private static final Hint hint = new ConditionHint(SaddledCondition.instance, "This permanent is saddled");

    public SaddleAbility(int value) {
        super(new SaddleEventEffect(), new SaddleCost(value));
        this.value = value;
        this.addHint(hint);
        this.setTiming(TimingRule.SORCERY);
        this.addWatcher(new SaddledMountWatcher());
    }

    private SaddleAbility(SaddleAbility ability) {
        super(ability);
        this.value = ability.value;
    }

    public static boolean applySaddle(Permanent permanent, Game game) {
        if (permanent == null) {
            return false;
        }
        SaddleAbility saddleAbility = permanent.getAbilities().stream().filter(a -> a instanceof SaddleAbility).map(a -> (SaddleAbility)a).findFirst().orElse(null);
        if (saddleAbility != null) {
            SaddleEventEffect effect = new SaddleEventEffect();
            effect.apply(game, saddleAbility);
            return true;
        }
        return false;
    }

    @Override
    public SaddleAbility copy() {
        return new SaddleAbility(this);
    }

    @Override
    public String getRule() {
        return "Saddle " + this.value + " <i>(Tap any number of other creatures you control with total power " + this.value + " or more: This Mount becomes saddled until end of turn. Saddle only as a sorcery.)</i>";
    }
}

