/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.EntersBattlefieldAllTriggeredAbility;
import mage.abilities.keyword.PairedPredicate;
import mage.abilities.keyword.SoulboundEntersOtherEffect;
import mage.constants.SetTargetPointer;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SoulbondEntersOtherAbility
extends EntersBattlefieldAllTriggeredAbility {
    private static final FilterCreaturePermanent soulbondFilter = new FilterCreaturePermanent();

    public SoulbondEntersOtherAbility() {
        super(Zone.BATTLEFIELD, new SoulboundEntersOtherEffect(), soulbondFilter, true, SetTargetPointer.PERMANENT);
        this.setRuleVisible(false);
    }

    public SoulbondEntersOtherAbility(SoulbondEntersOtherAbility ability) {
        super(ability);
    }

    @Override
    public String getRule() {
        return "Soulbond <i>(You may pair this creature with another unpaired creature when either enters the battlefield. They remain paired for as long as you control both of them.)</i>";
    }

    @Override
    public boolean checkInterveningIfClause(Game game) {
        Permanent sourcePermanent;
        return game.getBattlefield().countAll(this.filter, this.getControllerId(), game) > 0 && (sourcePermanent = game.getPermanent(this.getSourceId())) != null && sourcePermanent.isControlledBy(this.getControllerId()) && sourcePermanent.getPairedCard() == null;
    }

    @Override
    public SoulbondEntersOtherAbility copy() {
        return new SoulbondEntersOtherAbility(this);
    }

    static {
        soulbondFilter.add(Predicates.not(new PairedPredicate()));
        soulbondFilter.add(TargetController.YOU.getControllerPredicate());
        soulbondFilter.add(AnotherPredicate.instance);
    }
}

