/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.DiesSourceTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.constants.ComparisonType;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.targetadjustment.ManaValueTargetAdjuster;

public class SoulshiftAbility
extends DiesSourceTriggeredAbility {
    private final DynamicValue amount;

    public SoulshiftAbility(int amount) {
        this(StaticValue.get(amount));
    }

    public SoulshiftAbility(DynamicValue amount) {
        super(new ReturnToHandTargetEffect());
        this.amount = amount;
        FilterCard filter = new FilterCard("Spirit card from your graveyard");
        filter.add(SubType.SPIRIT.getPredicate());
        this.addTarget(new TargetCardInYourGraveyard(filter));
        this.setTargetAdjuster(new ManaValueTargetAdjuster(amount, ComparisonType.OR_LESS));
    }

    protected SoulshiftAbility(SoulshiftAbility ability) {
        super(ability);
        this.amount = ability.amount;
    }

    @Override
    public SoulshiftAbility copy() {
        return new SoulshiftAbility(this);
    }

    @Override
    public String getRule() {
        if (this.amount instanceof StaticValue) {
            return "Soulshift " + this.amount.toString() + " <i>(When this creature dies, you may return target Spirit card with mana value " + this.amount.toString() + " or less from your graveyard to your hand.)</i>";
        }
        return "{this} has soulshift X, where X is the number of " + this.amount.getMessage() + ". <i>(When this creature dies, you may return target Spirit card with mana value X or less from your graveyard to your hand.)</i>";
    }
}

