/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class SplitSecondEffect
extends ContinuousRuleModifyingEffectImpl {
    SplitSecondEffect() {
        super(Duration.WhileOnStack, Outcome.Detriment);
    }

    SplitSecondEffect(SplitSecondEffect effect) {
        super(effect);
    }

    @Override
    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        return "You can't cast spells or activate abilities that aren't mana abilities (Split second).";
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL || event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Optional<Ability> ability;
        if (event.getType() == GameEvent.EventType.CAST_SPELL) {
            return true;
        }
        return event.getType() == GameEvent.EventType.ACTIVATE_ABILITY && (ability = game.getAbility(event.getTargetId(), event.getSourceId())).isPresent() && !ability.get().isManaActivatedAbility();
    }

    @Override
    public SplitSecondEffect copy() {
        return new SplitSecondEffect(this);
    }
}

