/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class StationAbilityEffect
extends OneShotEffect {
    StationAbilityEffect() {
        super(Outcome.Benefit);
    }

    private StationAbilityEffect(StationAbilityEffect effect) {
        super(effect);
    }

    @Override
    public StationAbilityEffect copy() {
        return new StationAbilityEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        List creatures = (List)this.getValue("tappedPermanents");
        if (creatures == null) {
            return false;
        }
        int power = 0;
        for (Permanent creature : creatures) {
            GameEvent event = GameEvent.getEvent(GameEvent.EventType.STATION_PERMANENT, creature.getId(), source, source.getControllerId(), creature.getPower().getValue());
            if (game.replaceEvent(event)) continue;
            power += event.getAmount();
        }
        return power > 0 && permanent.addCounters(CounterType.CHARGE.createInstance(power), source, game);
    }
}

