/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.watchers.common.CastSpellLastTurnWatcher;
import org.apache.log4j.Logger;

class StormEffect
extends OneShotEffect {
    public StormEffect() {
        super(Outcome.Copy);
    }

    protected StormEffect(StormEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        MageObjectReference spellRef = (MageObjectReference)this.getValue("StormSpellRef");
        if (spellRef != null) {
            CastSpellLastTurnWatcher watcher = game.getState().getWatcher(CastSpellLastTurnWatcher.class);
            if (watcher != null) {
                Spell spell;
                int stormCount = watcher.getSpellOrder(spellRef, game) - 1;
                if (stormCount > 0 && (spell = (Spell)this.getValue("StormSpell")) != null) {
                    if (!game.isSimulation()) {
                        game.informPlayers("Storm: " + spell.getLogName() + " will be copied " + stormCount + " time" + (stormCount > 1 ? "s" : ""));
                    }
                    spell.createCopyOnStack(game, source, source.getControllerId(), true, stormCount);
                }
            } else {
                Logger.getLogger(StormEffect.class).fatal((Object)("CastSpellLastTurnWatcher not found. game = " + game.getGameType().toString()));
            }
            return true;
        }
        return false;
    }

    @Override
    public StormEffect copy() {
        return new StormEffect(this);
    }
}

