/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.SuspendAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class SuspendExileEffect
extends OneShotEffect {
    private int suspend;

    SuspendExileEffect(int suspend) {
        super(Outcome.PutCardInPlay);
        this.staticText = "Suspend " + (suspend == Integer.MAX_VALUE ? "X" : Integer.valueOf(suspend));
        this.suspend = suspend;
    }

    private SuspendExileEffect(SuspendExileEffect effect) {
        super(effect);
        this.suspend = effect.suspend;
    }

    @Override
    public SuspendExileEffect copy() {
        return new SuspendExileEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (card == null || controller == null) {
            return false;
        }
        UUID exileId = SuspendAbility.getSuspendExileId(controller.getId(), game);
        if (controller.moveCardToExileWithInfo(card, exileId, "Suspended cards of " + controller.getName(), source, game, Zone.HAND, true)) {
            if (this.suspend == Integer.MAX_VALUE) {
                this.suspend = CardUtil.getSourceCostsTag(game, source, "X", 0);
            }
            card.addCounters(CounterType.TIME.createInstance(this.suspend), source.getControllerId(), source, game);
            game.informPlayers(controller.getLogName() + " suspends (" + this.suspend + ") " + card.getLogName());
        }
        return true;
    }
}

