/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.StaticAbility;
import mage.abilities.icon.CardIconImpl;
import mage.abilities.icon.CardIconType;
import mage.constants.Zone;
import mage.util.CardUtil;

public class ToxicAbility
extends StaticAbility {
    private final int amount;

    public ToxicAbility(int amount) {
        super(Zone.BATTLEFIELD, null);
        this.amount = amount;
        this.addIcon(new CardIconImpl(CardIconType.ABILITY_INFECT, "Toxic " + amount));
    }

    private ToxicAbility(ToxicAbility ability) {
        super(ability);
        this.amount = ability.amount;
    }

    @Override
    public String getRule() {
        return "toxic " + this.amount + " <i>(Players dealt combat damage by this creature also get " + CardUtil.getSimpleCountersText(this.amount, "a", "poison") + ".)</i>";
    }

    @Override
    public ToxicAbility copy() {
        return new ToxicAbility(this);
    }

    public int getAmount() {
        return this.amount;
    }
}

