/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class UnearthLeavesBattlefieldEffect
extends ReplacementEffectImpl {
    public UnearthLeavesBattlefieldEffect() {
        super(Duration.OneUse, Outcome.Exile);
        this.staticText = "When {this} leaves the battlefield, exile it";
    }

    protected UnearthLeavesBattlefieldEffect(UnearthLeavesBattlefieldEffect effect) {
        super(effect);
    }

    @Override
    public UnearthLeavesBattlefieldEffect copy() {
        return new UnearthLeavesBattlefieldEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent;
        if (event.getTargetId().equals(source.getSourceId()) && (zEvent = (ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD && zEvent.getToZone() != Zone.EXILED) {
            return source.getStackMomentSourceZCC() == game.getState().getZoneChangeCounter(source.getSourceId());
        }
        return false;
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ((ZoneChangeEvent)event).setToZone(Zone.EXILED);
        return false;
    }
}

