/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class VanishingTriggeredAbility
extends TriggeredAbilityImpl {
    VanishingTriggeredAbility() {
        super(Zone.BATTLEFIELD, new SacrificeSourceEffect());
        this.setRuleVisible(false);
    }

    private VanishingTriggeredAbility(VanishingTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public VanishingTriggeredAbility copy() {
        return new VanishingTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_REMOVED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!CounterType.TIME.getName().equals(event.getData())) {
            return false;
        }
        Permanent permanent = this.getSourcePermanentIfItStillExists(game);
        return permanent != null && permanent.getCounters(game).getCount(CounterType.TIME) < 1;
    }

    @Override
    public String getRule() {
        return "When the last time counter is removed from {this}, sacrifice it.";
    }
}

