/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.mana;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.Mana;
import mage.abilities.ActivatedAbility;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.ManaAbility;
import mage.constants.AbilityType;
import mage.constants.ManaType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

public abstract class ActivatedManaAbilityImpl
extends ActivatedAbilityImpl
implements ManaAbility {
    protected List<Mana> netMana = new ArrayList<Mana>();
    protected boolean undoPossible;
    protected boolean poolDependant;

    public ActivatedManaAbilityImpl(Zone zone, ManaEffect effect, Cost cost) {
        super(AbilityType.ACTIVATED_MANA, zone);
        this.usesStack = false;
        this.undoPossible = true;
        if (effect != null) {
            this.addEffect(effect);
        }
        if (cost != null) {
            this.addCost(cost);
        }
    }

    protected ActivatedManaAbilityImpl(ActivatedManaAbilityImpl ability) {
        super(ability);
        this.netMana.addAll(ability.netMana);
        this.undoPossible = ability.undoPossible;
        this.poolDependant = ability.poolDependant;
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        StackObject stackObject = game.getStack().getFirstOrNull();
        if (stackObject instanceof Spell) {
            switch (((Spell)stackObject).getCurrentActivatingManaAbilitiesStep()) {
                case BEFORE: 
                case NORMAL: {
                    break;
                }
                case AFTER: {
                    return ActivatedAbility.ActivationStatus.getFalse();
                }
            }
        }
        return super.canActivate(playerId, game);
    }

    @Override
    public List<Mana> getNetMana(Game game) {
        if (this.netMana.isEmpty() || game != null && game.inCheckPlayableState()) {
            ArrayList<Mana> dynamicNetMana = new ArrayList<Mana>();
            for (Effect effect : this.getEffects()) {
                List<Mana> effectNetMana;
                if (!(effect instanceof ManaEffect) || (effectNetMana = ((ManaEffect)effect).getNetMana(game, this)) == null) continue;
                dynamicNetMana.addAll(effectNetMana);
            }
            return dynamicNetMana;
        }
        ArrayList<Mana> netManaCopy = new ArrayList<Mana>();
        for (Mana mana : this.netMana) {
            netManaCopy.add(mana.copy());
        }
        return netManaCopy;
    }

    @Override
    public List<Mana> getNetMana(Game game, Mana possibleManaInPool) {
        if (this.isPoolDependant()) {
            ArrayList<Mana> poolDependantNetMana = new ArrayList<Mana>();
            for (Effect effect : this.getEffects()) {
                List<Mana> effectNetMana;
                if (!(effect instanceof ManaEffect) || (effectNetMana = ((ManaEffect)effect).getNetMana(game, possibleManaInPool, this)) == null) continue;
                poolDependantNetMana.addAll(effectNetMana);
            }
            return poolDependantNetMana;
        }
        return this.getNetMana(game);
    }

    @Override
    public Set<ManaType> getProducableManaTypes(Game game) {
        HashSet<ManaType> manaTypes = new HashSet<ManaType>();
        for (Effect effect : this.getEffects()) {
            if (!(effect instanceof ManaEffect)) continue;
            manaTypes.addAll(((ManaEffect)effect).getProducableManaTypes(game, this));
        }
        return manaTypes;
    }

    @Override
    public boolean definesMana(Game game) {
        return !this.getNetMana(game).isEmpty();
    }

    public boolean isUndoPossible() {
        return this.undoPossible;
    }

    public void setUndoPossible(boolean undoPossible) {
        this.undoPossible = undoPossible;
    }

    @Override
    public boolean isPoolDependant() {
        return this.poolDependant;
    }

    @Override
    public ActivatedManaAbilityImpl setPoolDependant(boolean poolDependant) {
        this.poolDependant = poolDependant;
        return this;
    }
}

