/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.triggers;

import mage.abilities.effects.Effect;
import mage.abilities.triggers.AtStepTriggeredAbility;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

public class BeginningOfUpkeepTriggeredAbility
extends AtStepTriggeredAbility {
    public BeginningOfUpkeepTriggeredAbility(Effect effect) {
        this(effect, false);
    }

    public BeginningOfUpkeepTriggeredAbility(Effect effect, boolean optional) {
        this(TargetController.YOU, effect, optional);
    }

    public BeginningOfUpkeepTriggeredAbility(TargetController targetController, Effect effect, boolean optional) {
        this(Zone.BATTLEFIELD, targetController, effect, optional);
    }

    public BeginningOfUpkeepTriggeredAbility(Zone zone, TargetController targetController, Effect effect, boolean optional) {
        super(zone, targetController, effect, optional);
    }

    protected BeginningOfUpkeepTriggeredAbility(BeginningOfUpkeepTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public BeginningOfUpkeepTriggeredAbility copy() {
        return new BeginningOfUpkeepTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    @Override
    protected String generateTriggerPhrase() {
        switch (this.targetController) {
            case YOU: {
                return "At the beginning of your upkeep, ";
            }
            case NOT_YOU: {
                return "At the beginning of each other player's upkeep, ";
            }
            case OPPONENT: {
                return "At the beginning of each opponent's upkeep, ";
            }
            case ANY: {
                return "At the beginning of each upkeep, ";
            }
            case EACH_PLAYER: {
                return "At the beginning of each player's upkeep, ";
            }
            case CONTROLLER_ATTACHED_TO: {
                return "At the beginning of the upkeep of enchanted creature's controller, ";
            }
            case ENCHANTED: {
                return "At the beginning of enchanted player's upkeep, ";
            }
        }
        throw new UnsupportedOperationException("Unsupported TargetController in BeginningOfUpkeepTriggeredAbility: " + (Object)((Object)this.targetController));
    }
}

