/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectImpl;
import mage.Mana;
import mage.abilities.Abilities;
import mage.abilities.AbilitiesImpl;
import mage.abilities.Ability;
import mage.abilities.AbilityImpl;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.PlayLandAbility;
import mage.abilities.SpellAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.continuous.HasSubtypesSourceEffect;
import mage.abilities.keyword.ChangelingAbility;
import mage.abilities.keyword.FlashbackAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.abilities.keyword.ReconfigureAbility;
import mage.abilities.keyword.SunburstAbility;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.cards.Card;
import mage.cards.CardGraphicInfo;
import mage.cards.CardSetInfo;
import mage.cards.CardWithSpellOption;
import mage.cards.ExpansionSet;
import mage.cards.MeldCard;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.Sets;
import mage.cards.SplitCard;
import mage.cards.mock.MockableCard;
import mage.cards.repository.PluginClassloaderRegistery;
import mage.constants.CardType;
import mage.constants.ColoredManaSymbol;
import mage.constants.EmptyNames;
import mage.constants.Outcome;
import mage.constants.Rarity;
import mage.constants.SpellAbilityCastMode;
import mage.constants.SpellAbilityType;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.constants.TimingRule;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.Counters;
import mage.filter.FilterMana;
import mage.game.CardState;
import mage.game.ControllableOrOwnerable;
import mage.game.Game;
import mage.game.GameState;
import mage.game.ZoneChangeInfo;
import mage.game.ZonesHandler;
import mage.game.command.CommandObject;
import mage.game.events.AttachEvent;
import mage.game.events.AttachedEvent;
import mage.game.events.CounterRemovedEvent;
import mage.game.events.CountersRemovedEvent;
import mage.game.events.GameEvent;
import mage.game.events.RemoveCounterEvent;
import mage.game.events.RemoveCountersEvent;
import mage.game.events.StayAttachedEvent;
import mage.game.events.UnattachEvent;
import mage.game.events.UnattachedEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.util.CardUtil;
import mage.util.GameLog;
import mage.util.ManaUtil;
import mage.watchers.Watcher;
import org.apache.log4j.Logger;

public abstract class CardImpl
extends MageObjectImpl
implements Card {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(CardImpl.class);
    protected UUID ownerId;
    protected Rarity rarity;
    protected Class<? extends Card> secondSideCardClazz;
    protected Class<? extends Card> meldsWithClazz;
    protected Class<? extends MeldCard> meldsToClazz;
    protected MeldCard meldsToCard;
    protected Card secondSideCard;
    protected boolean nightCard;
    protected SpellAbility spellAbility;
    protected boolean flipCard;
    protected String flipCardName;
    protected boolean morphCard;
    protected List<UUID> attachments = new ArrayList<UUID>();
    protected boolean extraDeckCard = false;

    protected CardImpl(UUID ownerId, CardSetInfo setInfo, CardType[] cardTypes, String costs) {
        this(ownerId, setInfo, cardTypes, costs, SpellAbilityType.BASE);
    }

    protected CardImpl(UUID ownerId, CardSetInfo setInfo, CardType[] cardTypes, String costs, SpellAbilityType spellAbilityType) {
        this(ownerId, setInfo.getName());
        ActivatedAbilityImpl ability;
        this.rarity = setInfo.getRarity();
        this.setExpansionSetCode(setInfo.getExpansionSetCode());
        this.setUsesVariousArt(setInfo.getUsesVariousArt());
        this.setCardNumber(setInfo.getCardNumber());
        this.setImageFileName("");
        this.setImageNumber(0);
        this.cardType.addAll(Arrays.asList(cardTypes));
        this.manaCost.load(costs);
        this.setDefaultColor();
        if (this.isLand()) {
            ability = new PlayLandAbility(this.name);
            ability.setSourceId(this.getId());
            this.abilities.add(ability);
        } else {
            ability = new SpellAbility(this.manaCost, this.name, Zone.HAND, spellAbilityType);
            if (!this.isInstant()) {
                ability.setTiming(TimingRule.SORCERY);
            }
            ability.setSourceId(this.getId());
            this.abilities.add(ability);
        }
        CardGraphicInfo graphicInfo = setInfo.getGraphicInfo();
        if (graphicInfo != null) {
            if (graphicInfo.getFrameColor() != null) {
                this.frameColor = graphicInfo.getFrameColor().copy();
            }
            if (graphicInfo.getFrameStyle() != null) {
                this.frameStyle = graphicInfo.getFrameStyle();
            }
        }
        this.morphCard = false;
    }

    private void setDefaultColor() {
        this.color.setWhite(this.manaCost.containsColor(ColoredManaSymbol.W));
        this.color.setBlue(this.manaCost.containsColor(ColoredManaSymbol.U));
        this.color.setBlack(this.manaCost.containsColor(ColoredManaSymbol.B));
        this.color.setRed(this.manaCost.containsColor(ColoredManaSymbol.R));
        this.color.setGreen(this.manaCost.containsColor(ColoredManaSymbol.G));
    }

    protected CardImpl(UUID ownerId, String name) {
        this.ownerId = ownerId;
        this.name = name;
    }

    protected CardImpl(UUID id, UUID ownerId, String name) {
        super(id);
        this.ownerId = ownerId;
        this.name = name;
    }

    protected CardImpl(CardImpl card) {
        super(card);
        this.ownerId = card.ownerId;
        this.rarity = card.rarity;
        this.nightCard = card.nightCard;
        this.secondSideCardClazz = card.secondSideCardClazz;
        this.secondSideCard = null;
        if (card.secondSideCard instanceof MockableCard) {
            this.secondSideCard = card.secondSideCard.copy();
        }
        this.meldsWithClazz = card.meldsWithClazz;
        this.meldsToClazz = card.meldsToClazz;
        this.meldsToCard = null;
        if (card.meldsToCard instanceof MockableCard) {
            this.meldsToCard = card.meldsToCard.copy();
        }
        this.spellAbility = null;
        this.flipCard = card.flipCard;
        this.flipCardName = card.flipCardName;
        this.morphCard = card.morphCard;
        this.extraDeckCard = card.extraDeckCard;
        this.attachments.addAll(card.attachments);
    }

    @Override
    public void assignNewId() {
        this.objectId = UUID.randomUUID();
        this.abilities.newOriginalId();
        this.abilities.setSourceId(this.objectId);
        if (this.spellAbility != null) {
            this.spellAbility.setSourceId(this.objectId);
        }
    }

    public static Card createCard(String name, CardSetInfo setInfo) {
        try {
            return CardImpl.createCard(Class.forName(name), setInfo);
        }
        catch (ClassNotFoundException ex) {
            try {
                return CardImpl.createCard(PluginClassloaderRegistery.forName(name), setInfo);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.fatal((Object)("Error loading card: " + name), (Throwable)ex);
                return null;
            }
        }
    }

    public static Card createCard(Class<?> clazz, CardSetInfo setInfo) {
        return CardImpl.createCard(clazz, setInfo, null);
    }

    public static Card createCard(Class<?> clazz, CardSetInfo setInfo, List<String> errorList) {
        String setCode = null;
        try {
            Card card;
            if (setInfo == null) {
                Constructor<?> con = clazz.getConstructor(UUID.class);
                card = (Card)con.newInstance(new Object[]{null});
            } else {
                setCode = setInfo.getExpansionSetCode();
                Constructor<?> con = clazz.getConstructor(UUID.class, CardSetInfo.class);
                card = (Card)con.newInstance(null, setInfo);
            }
            return card;
        }
        catch (Exception e) {
            String err = "Error loading card: " + clazz.getCanonicalName() + " (" + setCode + ")";
            if (errorList != null) {
                errorList.add(err);
            }
            if (e instanceof InvocationTargetException) {
                logger.fatal((Object)err, ((InvocationTargetException)e).getTargetException());
            } else {
                logger.fatal((Object)err, (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public UUID getOwnerId() {
        return this.ownerId;
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    @Override
    public void setRarity(Rarity rarity) {
        this.rarity = rarity;
    }

    @Override
    public void addInfo(String key, String value, Game game) {
        game.getState().getCardState(this.objectId).addInfo(key, value);
    }

    @Override
    public List<String> getRules() {
        Abilities<Ability> sourceAbilities = this.getAbilities();
        return CardUtil.getCardRulesWithAdditionalInfo(this, sourceAbilities, sourceAbilities);
    }

    @Override
    public List<String> getRules(Game game) {
        Abilities<Ability> sourceAbilities = this.getAbilities(game);
        return CardUtil.getCardRulesWithAdditionalInfo(game, this, sourceAbilities, sourceAbilities);
    }

    @Override
    public Abilities<Ability> getAbilities() {
        return super.getAbilities();
    }

    @Override
    public Abilities<Ability> getAbilities(Game game) {
        if (game == null) {
            return this.abilities;
        }
        CardState cardState = game.getState().getCardState(this.getId());
        if (cardState == null) {
            return this.abilities;
        }
        AbilitiesImpl<Ability> all = new AbilitiesImpl<Ability>();
        if (!cardState.hasLostAllAbilities()) {
            all.addAll(this.abilities);
        }
        all.addAll(cardState.getAbilities());
        if (!this.getId().equals(this.getMainCard().getId())) {
            CardState mainCardState = game.getState().getCardState(this.getMainCard().getId());
            if (this.getSpellAbility() != null && mainCardState != null && !mainCardState.hasLostAllAbilities() && mainCardState.getAbilities().containsClass(FlashbackAbility.class)) {
                FlashbackAbility flash = new FlashbackAbility(this, this.getManaCost());
                flash.setSourceId(this.getId());
                flash.setControllerId(this.getOwnerId());
                flash.setSpellAbilityType(this.getSpellAbility().getSpellAbilityType());
                flash.setAbilityName(this.getName());
                all.add(flash);
            }
        }
        return all;
    }

    @Override
    public void looseAllAbilities(Game game) {
        CardState cardState = game.getState().getCardState(this.getId());
        cardState.setLostAllAbilities(true);
        cardState.getAbilities().clear();
    }

    @Override
    public boolean hasAbility(Ability ability, Game game) {
        return this.getAbilities(game).contains(ability);
    }

    @Override
    public void addAbility(Ability ability) {
        TriggeredAbility triggeredAbility;
        ability.setSourceId(this.getId());
        this.abilities.add(ability);
        this.abilities.addAll(ability.getSubAbilities());
        if (this instanceof PermanentCard) {
            throw new IllegalArgumentException("Wrong code usage. Don't use that method for permanents, use permanent.addAbility(a, source, game) instead.");
        }
        if (ability instanceof ActivatedManaAbilityImpl) {
            ActivatedManaAbilityImpl manaAbility = (ActivatedManaAbilityImpl)ability;
            String rule = manaAbility.getRule().toLowerCase(Locale.ENGLISH);
            if ((manaAbility.getEffects().stream().anyMatch(e -> e.getOutcome().equals((Object)Outcome.DrawCard)) || rule.contains("reveal ") || rule.contains("draw ")) && manaAbility.isUndoPossible()) {
                throw new IllegalArgumentException("Ability contains draw/reveal effect, but isUndoPossible is true. Ability: " + ability.getClass().getSimpleName() + "; " + ability.getRule());
            }
        }
        if (EntersBattlefieldTriggeredAbility.ENABLE_TRIGGER_PHRASE_AUTO_FIX && ability instanceof TriggeredAbility && (triggeredAbility = (TriggeredAbility)ability).getTriggerPhrase() != null && triggeredAbility.getTriggerPhrase().startsWith("When {this} enters")) {
            String etbDescription = EntersBattlefieldTriggeredAbility.getThisObjectDescription(this);
            triggeredAbility.setTriggerPhrase(triggeredAbility.getTriggerPhrase().replace("{this}", etbDescription));
        }
    }

    protected void addAbility(Ability ability, Watcher watcher) {
        this.addAbility(ability);
        ability.addWatcher(watcher);
    }

    public void replaceSpellAbility(SpellAbility newAbility) {
        SpellAbility oldAbility = this.getSpellAbility();
        while (oldAbility != null) {
            this.abilities.remove(oldAbility);
            this.spellAbility = null;
            oldAbility = this.getSpellAbility();
        }
        if (newAbility != null) {
            this.addAbility(newAbility);
        }
    }

    @Override
    public SpellAbility getSpellAbility() {
        if (this.spellAbility == null) {
            for (Ability ability : this.abilities.getActivatedAbilities(Zone.HAND)) {
                if (!(ability instanceof SpellAbility) || ((SpellAbility)ability).getSpellAbilityType() == SpellAbilityType.BASE_ALTERNATE) continue;
                this.spellAbility = (SpellAbility)ability;
                return this.spellAbility;
            }
        }
        return this.spellAbility;
    }

    @Override
    public void setOwnerId(UUID ownerId) {
        this.ownerId = ownerId;
        this.abilities.setControllerId(ownerId);
    }

    @Override
    public UUID getControllerOrOwnerId() {
        return this.getOwnerId();
    }

    @Override
    public List<Mana> getMana() {
        ArrayList<Mana> mana = new ArrayList<Mana>();
        for (ActivatedManaAbilityImpl ability : this.abilities.getActivatedManaAbilities(Zone.BATTLEFIELD)) {
            mana.addAll(ability.getNetMana(null));
        }
        return mana;
    }

    @Override
    public boolean moveToZone(Zone toZone, Ability source, Game game, boolean flag) {
        return this.moveToZone(toZone, source, game, flag, null);
    }

    @Override
    public boolean moveToZone(Zone toZone, Ability source, Game game, boolean flag, List<UUID> appliedEffects) {
        Zone fromZone = game.getState().getZone(this.objectId);
        ZoneChangeEvent event = new ZoneChangeEvent(this.objectId, source, this.ownerId, fromZone, toZone, appliedEffects);
        if (null != toZone) {
            ZoneChangeInfo zoneChangeInfo;
            switch (toZone) {
                case LIBRARY: {
                    zoneChangeInfo = new ZoneChangeInfo.Library(event, flag);
                    break;
                }
                case BATTLEFIELD: {
                    zoneChangeInfo = new ZoneChangeInfo.Battlefield(event, flag, source);
                    break;
                }
                default: {
                    zoneChangeInfo = new ZoneChangeInfo(event);
                }
            }
            return ZonesHandler.moveCard(zoneChangeInfo, game, source);
        }
        return false;
    }

    @Override
    public boolean cast(Game game, Zone fromZone, SpellAbility ability, UUID controllerId) {
        Card mainCard = this.getMainCard();
        ZoneChangeEvent event = new ZoneChangeEvent(mainCard.getId(), (Ability)ability, controllerId, fromZone, Zone.STACK);
        Spell spell = new Spell(this, ability.getSpellAbilityToResolve(game), controllerId, event.getFromZone(), game);
        ZoneChangeInfo.Stack info = new ZoneChangeInfo.Stack(event, spell);
        return ZonesHandler.cast(info, ability, game);
    }

    @Override
    public boolean moveToExile(UUID exileId, String name, Ability source, Game game) {
        return this.moveToExile(exileId, name, source, game, null);
    }

    @Override
    public boolean moveToExile(UUID exileId, String name, Ability source, Game game, List<UUID> appliedEffects) {
        Zone fromZone = game.getState().getZone(this.objectId);
        ZoneChangeEvent event = new ZoneChangeEvent(this.objectId, source, this.ownerId, fromZone, Zone.EXILED, appliedEffects);
        ZoneChangeInfo.Exile info = new ZoneChangeInfo.Exile(event, exileId, name);
        return ZonesHandler.moveCard(info, game, source);
    }

    @Override
    public boolean putOntoBattlefield(Game game, Zone fromZone, Ability source, UUID controllerId) {
        return this.putOntoBattlefield(game, fromZone, source, controllerId, false, false, null);
    }

    @Override
    public boolean putOntoBattlefield(Game game, Zone fromZone, Ability source, UUID controllerId, boolean tapped) {
        return this.putOntoBattlefield(game, fromZone, source, controllerId, tapped, false, null);
    }

    @Override
    public boolean putOntoBattlefield(Game game, Zone fromZone, Ability source, UUID controllerId, boolean tapped, boolean faceDown) {
        return this.putOntoBattlefield(game, fromZone, source, controllerId, tapped, faceDown, null);
    }

    @Override
    public boolean putOntoBattlefield(Game game, Zone fromZone, Ability source, UUID controllerId, boolean tapped, boolean faceDown, List<UUID> appliedEffects) {
        ZoneChangeEvent event = new ZoneChangeEvent(this.objectId, source, controllerId, fromZone, Zone.BATTLEFIELD, appliedEffects);
        ZoneChangeInfo.Battlefield info = new ZoneChangeInfo.Battlefield(event, faceDown, tapped, source);
        return ZonesHandler.moveCard(info, game, source);
    }

    @Override
    public boolean removeFromZone(Game game, Zone fromZone, Ability source) {
        boolean removed = false;
        ControllableOrOwnerable lkiObject = null;
        if (this.isCopy()) {
            removed = true;
        } else {
            switch (fromZone) {
                case GRAVEYARD: {
                    removed = game.getPlayer(this.ownerId).removeFromGraveyard(this, game);
                    break;
                }
                case HAND: {
                    removed = game.getPlayer(this.ownerId).removeFromHand(this, game);
                    break;
                }
                case LIBRARY: {
                    removed = game.getPlayer(this.ownerId).removeFromLibrary(this, game);
                    break;
                }
                case EXILED: {
                    if (game.getExile().getCard(this.getId(), game) == null) break;
                    removed = game.getExile().removeCard(this);
                    break;
                }
                case STACK: {
                    Spell stackObject = this.getSpellAbility() != null ? game.getStack().getSpell(this.getSpellAbility().getId(), false) : game.getStack().getSpell(this.getId(), false);
                    if (stackObject == null && this instanceof SplitCard && (stackObject = game.getStack().getSpell(((SplitCard)this).getLeftHalfCard().getId(), false)) == null) {
                        stackObject = game.getStack().getSpell(((SplitCard)this).getRightHalfCard().getId(), false);
                    }
                    if (stackObject == null && this instanceof ModalDoubleFacedCard && (stackObject = game.getStack().getSpell(((ModalDoubleFacedCard)this).getLeftHalfCard().getId(), false)) == null) {
                        stackObject = game.getStack().getSpell(((ModalDoubleFacedCard)this).getRightHalfCard().getId(), false);
                    }
                    if (stackObject == null && this instanceof CardWithSpellOption) {
                        stackObject = game.getStack().getSpell(((CardWithSpellOption)this).getSpellCard().getId(), false);
                    }
                    if (stackObject == null) {
                        stackObject = game.getStack().getSpell(this.getId(), false);
                    }
                    if (stackObject == null) break;
                    removed = game.getStack().remove(stackObject, game);
                    lkiObject = stackObject;
                    break;
                }
                case COMMAND: {
                    for (CommandObject commandObject : game.getState().getCommand()) {
                        if (!commandObject.getId().equals(this.objectId)) continue;
                        lkiObject = commandObject;
                    }
                    if (lkiObject == null) break;
                    removed = game.getState().getCommand().remove(lkiObject);
                    break;
                }
                case OUTSIDE: {
                    if (game.getPlayer(this.ownerId).getSideboard().contains(this.getId())) {
                        game.getPlayer(this.ownerId).getSideboard().remove(this.getId());
                        removed = true;
                        break;
                    }
                    if (game.getPhase() == null) {
                        removed = true;
                        break;
                    }
                    removed = true;
                    break;
                }
                case BATTLEFIELD: {
                    removed = true;
                    break;
                }
                default: {
                    MageObject sourceObject = game.getObject(source);
                    logger.fatal((Object)("Invalid from zone [" + (Object)((Object)fromZone) + "] for card [" + this.getIdName() + "] source [" + (sourceObject != null ? sourceObject.getName() : "null") + ']'));
                }
            }
        }
        if (removed) {
            if (fromZone != Zone.OUTSIDE) {
                game.rememberLKI(fromZone, (MageObject)((Object)(lkiObject != null ? lkiObject : this)));
            }
        } else {
            logger.warn((Object)("Couldn't find card in fromZone, card=" + this.getIdName() + ", fromZone=" + (Object)((Object)fromZone)));
        }
        return removed;
    }

    @Override
    public void applyEnterWithCounters(Permanent permanent, Ability source, Game game) {
        Counters countersToAdd = game.getEnterWithCounters(permanent.getId());
        if (countersToAdd != null) {
            for (Counter counter : countersToAdd.values()) {
                permanent.addCounters(counter, source.getControllerId(), source, game);
            }
            game.setEnterWithCounters(permanent.getId(), null);
        }
    }

    @Override
    public void setFaceDown(boolean value, Game game) {
        game.getState().getCardState(this.objectId).setFaceDown(value);
    }

    @Override
    public boolean isFaceDown(Game game) {
        return game.getState().getCardState(this.objectId).isFaceDown();
    }

    @Override
    public boolean turnFaceUp(Ability source, Game game, UUID playerId) {
        GameEvent event = GameEvent.getEvent(GameEvent.EventType.TURN_FACE_UP, this.getId(), source, playerId);
        if (!game.replaceEvent(event)) {
            this.setFaceDown(false, game);
            for (Ability ability : this.abilities) {
                if (!ability.getWorksFaceDown() || ability.getRuleVisible()) continue;
                ability.setRuleVisible(true);
            }
            game.processAction();
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.TURNED_FACE_UP, this.getId(), source, playerId));
            return true;
        }
        return false;
    }

    @Override
    public boolean turnFaceDown(Ability source, Game game, UUID playerId) {
        GameEvent event = GameEvent.getEvent(GameEvent.EventType.TURN_FACE_DOWN, this.getId(), source, playerId);
        if (!game.replaceEvent(event)) {
            this.setFaceDown(true, game);
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.TURNED_FACE_DOWN, this.getId(), source, playerId));
            return true;
        }
        return false;
    }

    @Override
    public boolean isTransformable() {
        return this.secondSideCardClazz != null || this.nightCard;
    }

    @Override
    public final Card getSecondCardFace() {
        if (this.secondSideCardClazz == null && this.secondSideCard == null) {
            return null;
        }
        if (this.secondSideCard == null) {
            this.secondSideCard = this.initSecondSideCard(this.secondSideCardClazz);
            if (this.secondSideCard != null && this.secondSideCard.getSpellAbility() != null) {
                this.secondSideCard.getSpellAbility().setSourceId(this.getId());
                this.secondSideCard.getSpellAbility().setSpellAbilityType(SpellAbilityType.BASE_ALTERNATE);
                this.secondSideCard.getSpellAbility().setSpellAbilityCastMode(SpellAbilityCastMode.TRANSFORMED);
            }
        }
        return this.secondSideCard;
    }

    private Card initSecondSideCard(Class<? extends Card> cardClazz) {
        ExpansionSet.SetCardInfo info = Sets.findCardByClass(cardClazz, this.getExpansionSetCode(), this.getCardNumber());
        if (info == null) {
            return null;
        }
        return CardImpl.createCard(cardClazz, new CardSetInfo(info.getName(), this.getExpansionSetCode(), info.getCardNumber(), info.getRarity(), info.getGraphicInfo()));
    }

    @Override
    public SpellAbility getSecondFaceSpellAbility() {
        Card secondFace = this.getSecondCardFace();
        if (secondFace == null || secondFace.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Wrong code usage: getSecondFaceSpellAbility can only be used for double faced card (main side), broken card: " + this.getName());
        }
        return secondFace.getSpellAbility();
    }

    @Override
    public boolean meldsWith(Card card) {
        return this.meldsWithClazz != null && this.meldsWithClazz.isInstance(card.getMainCard());
    }

    @Override
    public Class<? extends Card> getMeldsToClazz() {
        return this.meldsToClazz;
    }

    @Override
    public MeldCard getMeldsToCard() {
        if (this.meldsToClazz == null && this.meldsToCard == null) {
            return null;
        }
        if (this.meldsToCard == null) {
            this.meldsToCard = (MeldCard)this.initSecondSideCard(this.meldsToClazz);
        }
        return this.meldsToCard;
    }

    @Override
    public boolean isNightCard() {
        return this.nightCard;
    }

    @Override
    public boolean isFlipCard() {
        return this.flipCard;
    }

    @Override
    public String getFlipCardName() {
        return this.flipCardName;
    }

    @Override
    public Counters getCounters(Game game) {
        return this.getCounters(game.getState());
    }

    @Override
    public Counters getCounters(GameState state) {
        return state.getCardState(this.objectId).getCounters();
    }

    @Override
    public boolean addCounters(Counter counter, Ability source, Game game) {
        return this.addCounters(counter, source.getControllerId(), source, game);
    }

    @Override
    public boolean addCounters(Counter counter, UUID playerAddingCounters, Ability source, Game game) {
        return this.addCounters(counter, playerAddingCounters, source, game, null, true);
    }

    @Override
    public boolean addCounters(Counter counter, UUID playerAddingCounters, Ability source, Game game, boolean isEffect) {
        return this.addCounters(counter, playerAddingCounters, source, game, null, isEffect);
    }

    @Override
    public boolean addCounters(Counter counter, UUID playerAddingCounters, Ability source, Game game, List<UUID> appliedEffects) {
        return this.addCounters(counter, playerAddingCounters, source, game, appliedEffects, true);
    }

    @Override
    public boolean addCounters(Counter counter, UUID playerAddingCounters, Ability source, Game game, List<UUID> appliedEffects, boolean isEffect) {
        return this.addCounters(counter, playerAddingCounters, source, game, appliedEffects, isEffect, Integer.MAX_VALUE);
    }

    @Override
    public boolean addCounters(Counter counter, UUID playerAddingCounters, Ability source, Game game, List<UUID> appliedEffects, boolean isEffect, int maxCounters) {
        if (this instanceof Permanent && !((Permanent)((Object)this)).isPhasedIn()) {
            return false;
        }
        boolean returnCode = true;
        GameEvent addingAllEvent = GameEvent.getEvent(GameEvent.EventType.ADD_COUNTERS, this.objectId, source, playerAddingCounters, counter.getName(), counter.getCount());
        addingAllEvent.setAppliedEffects(appliedEffects);
        addingAllEvent.setFlag(isEffect);
        if (!game.replaceEvent(addingAllEvent)) {
            int amount = maxCounters < Integer.MAX_VALUE ? Integer.min(addingAllEvent.getAmount(), maxCounters - this.getCounters(game).getCount(counter.getName())) : addingAllEvent.getAmount();
            boolean isEffectFlag = addingAllEvent.getFlag();
            int finalAmount = amount;
            for (int i = 0; i < amount; ++i) {
                Counter eventCounter = counter.copy();
                eventCounter.remove(eventCounter.getCount() - 1);
                GameEvent addingOneEvent = GameEvent.getEvent(GameEvent.EventType.ADD_COUNTER, this.objectId, source, playerAddingCounters, counter.getName(), 1);
                addingOneEvent.setAppliedEffects(appliedEffects);
                addingOneEvent.setFlag(isEffectFlag);
                if (!game.replaceEvent(addingOneEvent)) {
                    this.getCounters(game).addCounter(eventCounter);
                    GameEvent addedOneEvent = GameEvent.getEvent(GameEvent.EventType.COUNTER_ADDED, this.objectId, source, playerAddingCounters, counter.getName(), 1);
                    addedOneEvent.setFlag(addingOneEvent.getFlag());
                    game.fireEvent(addedOneEvent);
                    continue;
                }
                --finalAmount;
                returnCode = false;
            }
            if (finalAmount > 0) {
                GameEvent addedAllEvent = GameEvent.getEvent(GameEvent.EventType.COUNTERS_ADDED, this.objectId, source, playerAddingCounters, counter.getName(), amount);
                addedAllEvent.setFlag(isEffectFlag);
                game.fireEvent(addedAllEvent);
            } else {
                returnCode = false;
            }
        } else {
            returnCode = false;
        }
        return returnCode;
    }

    @Override
    public int removeCounters(String counterName, int amount, Ability source, Game game, boolean isDamage) {
        if (amount <= 0) {
            return 0;
        }
        if (this.getCounters(game).getCount(counterName) <= 0) {
            return 0;
        }
        RemoveCountersEvent removeCountersEvent = new RemoveCountersEvent(counterName, this, source, amount, isDamage);
        if (game.replaceEvent(removeCountersEvent)) {
            return 0;
        }
        int finalAmount = 0;
        for (int i = 0; i < removeCountersEvent.getAmount(); ++i) {
            GameEvent event = new RemoveCounterEvent(counterName, this, source, isDamage);
            if (game.replaceEvent(event)) continue;
            if (!this.getCounters(game).removeCounter(counterName, 1)) break;
            event = new CounterRemovedEvent(counterName, this, source, isDamage);
            game.fireEvent(event);
            ++finalAmount;
        }
        CountersRemovedEvent event = new CountersRemovedEvent(counterName, this, source, finalAmount, isDamage);
        game.fireEvent(event);
        return finalAmount;
    }

    @Override
    public int removeCounters(Counter counter, Ability source, Game game, boolean isDamage) {
        return counter != null ? this.removeCounters(counter.getName(), counter.getCount(), source, game, isDamage) : 0;
    }

    @Override
    public int removeAllCounters(Ability source, Game game, boolean isDamage) {
        int amountBefore = this.getCounters(game).getTotalCount();
        for (Counter counter : this.getCounters(game).copy().values()) {
            this.removeCounters(counter.getName(), counter.getCount(), source, game, isDamage);
        }
        int amountAfter = this.getCounters(game).getTotalCount();
        return Math.max(0, amountBefore - amountAfter);
    }

    @Override
    public int removeAllCounters(String counterName, Ability source, Game game, boolean isDamage) {
        int amountBefore = this.getCounters(game).getCount(counterName);
        this.removeCounters(counterName, amountBefore, source, game, isDamage);
        int amountAfter = this.getCounters(game).getCount(counterName);
        return Math.max(0, amountBefore - amountAfter);
    }

    @Override
    public String getLogName() {
        if (this.name.isEmpty()) {
            return GameLog.getNeutralColoredText(EmptyNames.FACE_DOWN_CREATURE.getObjectName());
        }
        return GameLog.getColoredObjectIdName(this);
    }

    @Override
    public Card getMainCard() {
        return this;
    }

    @Override
    public FilterMana getColorIdentity() {
        return ManaUtil.getColorIdentity(this);
    }

    @Override
    public void setZone(Zone zone, Game game) {
        game.setZone(this.getId(), zone);
    }

    @Override
    public void setSpellAbility(SpellAbility ability) {
        this.spellAbility = ability;
    }

    @Override
    public List<UUID> getAttachments() {
        return this.attachments;
    }

    @Override
    public boolean cantBeAttachedBy(MageObject attachment, Ability source, Game game, boolean silentMode) {
        boolean canAttach = true;
        for (ProtectionAbility ability : this.getAbilities(game).getProtectionAbilities()) {
            if (attachment.hasSubtype(SubType.AURA, game) && !ability.removesAuras() || attachment.hasSubtype(SubType.EQUIPMENT, game) && !ability.removesEquipment() || attachment.getId().equals(ability.getAuraIdNotToBeRemoved()) || ability.canTarget(attachment, game)) continue;
            canAttach &= ability.getDoesntRemoveControlled() && Objects.equals(this.getControllerOrOwnerId(), game.getControllerId(attachment.getId()));
        }
        if (attachment.hasSubtype(SubType.AURA, game)) {
            SpellAbility spellAbility = null;
            UUID controller = null;
            Permanent attachmentPermanent = game.getPermanent(attachment.getId());
            if (attachmentPermanent != null) {
                spellAbility = attachmentPermanent.getSpellAbility();
                controller = attachmentPermanent.getControllerId();
            } else {
                Card attachmentCard = game.getCard(attachment.getId());
                if (attachmentCard != null) {
                    spellAbility = attachmentCard.getSpellAbility();
                    controller = source != null ? source.getControllerId() : attachmentCard.getControllerOrOwnerId();
                }
            }
            if (controller != null && spellAbility != null && !spellAbility.getTargets().isEmpty()) {
                canAttach &= ((Target)spellAbility.getTargets().get(0)).copy().withNotTarget(true).stillLegalTarget(controller, this.getId(), source, game);
            }
        }
        return !canAttach || game.getContinuousEffects().preventedByRuleModification(new StayAttachedEvent(this.getId(), attachment.getId(), source), null, game, silentMode);
    }

    @Override
    public boolean addAttachment(UUID permanentId, Ability source, Game game) {
        if (permanentId == null || this.attachments.contains(permanentId) || permanentId.equals(this.getId())) {
            return false;
        }
        Permanent attachment = game.getPermanent(permanentId);
        if (attachment == null) {
            attachment = game.getPermanentEntering(permanentId);
        }
        if (attachment == null) {
            return false;
        }
        if (attachment.hasSubtype(SubType.EQUIPMENT, game) && attachment.isCreature(game) && !attachment.getAbilities(game).containsClass(ReconfigureAbility.class)) {
            return false;
        }
        if (attachment.hasSubtype(SubType.FORTIFICATION, game) && (attachment.isCreature(game) || !this.isLand(game))) {
            return false;
        }
        if (this.cantBeAttachedBy(attachment, source, game, false)) {
            return false;
        }
        if (game.replaceEvent(new AttachEvent(this.objectId, attachment, source))) {
            return false;
        }
        this.attachments.add(permanentId);
        attachment.attachTo(this.objectId, source, game);
        game.fireEvent(new AttachedEvent(this.objectId, attachment, source));
        return true;
    }

    @Override
    public boolean removeAttachment(UUID permanentId, Ability source, Game game) {
        if (this.attachments.contains(permanentId)) {
            Permanent attachment = game.getPermanent(permanentId);
            if (attachment != null) {
                attachment.unattach(game);
            }
            if (!game.replaceEvent(new UnattachEvent(this.objectId, permanentId, attachment, source))) {
                this.attachments.remove(permanentId);
                game.fireEvent(new UnattachedEvent(this.objectId, permanentId, attachment, source));
                return true;
            }
        }
        return false;
    }

    @Override
    public List<CardType> getCardTypeForDeckbuilding() {
        return this.getCardType();
    }

    @Override
    public boolean hasCardTypeForDeckbuilding(CardType cardType) {
        return this.getCardTypeForDeckbuilding().contains((Object)cardType);
    }

    @Override
    public boolean hasSubTypeForDeckbuilding(SubType subType) {
        if (this.hasSubtype(subType, null)) {
            return true;
        }
        if (this.getAbilities().stream().filter(SimpleStaticAbility.class::isInstance).map(Ability::getAllEffects).flatMap(Collection::stream).filter(HasSubtypesSourceEffect.class::isInstance).map(HasSubtypesSourceEffect.class::cast).anyMatch(effect -> effect.hasSubtype(subType))) {
            return true;
        }
        return subType.getSubTypeSet() == SubTypeSet.CreatureType && this.getAbilities().containsClass(ChangelingAbility.class);
    }

    public boolean caresAboutManaColor(Game game) {
        if (this.abilities.containsClass(SunburstAbility.class)) {
            return true;
        }
        for (Ability ability : this.getAbilities(game)) {
            if (!((AbilityImpl)ability).caresAboutManaColor()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExtraDeckCard() {
        return this.extraDeckCard;
    }
}

