/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.ObjectColor;
import mage.cards.Card;
import mage.cards.CardGraphicInfo;
import mage.cards.FrameStyle;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.collation.BoosterCollator;
import mage.constants.CardType;
import mage.constants.Rarity;
import mage.constants.SetType;
import mage.constants.SuperType;
import mage.filter.FilterMana;
import mage.util.CardUtil;
import mage.util.RandomUtil;
import org.apache.log4j.Logger;

public abstract class ExpansionSet
implements Serializable {
    private static final Logger logger = Logger.getLogger(ExpansionSet.class);
    public static final CardGraphicInfo FULL_ART_BFZ_VARIOUS = new CardGraphicInfo(FrameStyle.BFZ_FULL_ART_BASIC, true);
    public static final CardGraphicInfo FULL_ART_ZEN_VARIOUS = new CardGraphicInfo(FrameStyle.ZEN_FULL_ART_BASIC, true);
    public static final CardGraphicInfo FULL_ART_UST_VARIOUS = new CardGraphicInfo(FrameStyle.UST_FULL_ART_BASIC, true);
    public static final CardGraphicInfo NORMAL_ART = null;
    public static final CardGraphicInfo NON_FULL_USE_VARIOUS = new CardGraphicInfo(null, true);
    public static final CardGraphicInfo RETRO_ART = new CardGraphicInfo(FrameStyle.RETRO, false);
    public static final CardGraphicInfo RETRO_ART_USE_VARIOUS = new CardGraphicInfo(FrameStyle.RETRO, true);
    public static final CardGraphicInfo FULL_ART = new CardGraphicInfo(FrameStyle.MPOP_FULL_ART_BASIC, false);
    public static final CardGraphicInfo FULL_ART_USE_VARIOUS = new CardGraphicInfo(FrameStyle.MPOP_FULL_ART_BASIC, true);
    public static final boolean HIDE_MUTATE_CARDS = true;
    public static final Set<String> MUTATE_CARD_NAMES = new HashSet<String>(Arrays.asList("Archipelagore", "Auspicious Starrix", "Boneyard Lurker", "Cavern Whisperer", "Chittering Harvester", "Cloudpiercer", "Cubwarden", "Dirge Bat", "Dreamtail Heron", "Everquill Phoenix", "Gemrazer", "Glowstone Recluse", "Huntmaster Liger", "Illuna, Apex of Wishes", "Insatiable Hemophage", "Lore Drakkis", "Majestic Auricorn", "Mindleecher", "Migratory Greathorn", "Necropanther", "Nethroi, Apex of Death", "Otrimi, the Ever-Playful", "Parcelbeast", "Porcuparrot", "Pouncing Shoreshark", "Regal Leosaur", "Sawtusk Demolisher", "Sea-Dasher Octopus", "Snapdax, Apex of the Hunt", "Souvenir Snatcher", "Sawtusk Demolisher", "Trumpeting Gnarr", "Vadrok, Apex of Thunder", "Vulpikeet"));
    protected final List<SetCardInfo> cards = new ArrayList<SetCardInfo>();
    protected String name;
    protected String code;
    protected Date releaseDate;
    protected ExpansionSet parentSet;
    protected SetType setType;
    protected boolean hasBasicLands = true;
    protected String blockName;
    protected boolean rotationSet = false;
    protected boolean hasBoosters = false;
    protected int numBoosterSpecial;
    protected int numBoosterLands;
    protected int ratioBoosterSpecialLand = 0;
    protected int ratioBoosterSpecialLandNumerator = 1;
    protected int ratioBoosterSpecialCommon = 0;
    protected double ratioBoosterSpecialRare = 0.0;
    protected double ratioBoosterSpecialMythic;
    protected int numBoosterCommon;
    protected int numBoosterUncommon;
    protected int numBoosterRare;
    protected int numBoosterDoubleFaced;
    protected double ratioBoosterMythic;
    protected boolean hasUnbalancedColors = false;
    protected boolean hasOnlyMulticolorCards = false;
    protected boolean hasAlternateBoosterPrintings = true;
    protected int maxCardNumberInBooster;
    protected final EnumMap<Rarity, List<CardInfo>> savedCards = new EnumMap(Rarity.class);
    protected final EnumMap<Rarity, List<CardInfo>> savedSpecialCards = new EnumMap(Rarity.class);
    protected Map<String, List<CardInfo>> savedReprints = null;
    protected final Map<String, CardInfo> inBoosterMap = new HashMap<String, CardInfo>();

    public static ExpansionSetComparator getComparator() {
        return ExpansionSetComparator.instance;
    }

    protected ExpansionSet(String name, String code, Date releaseDate, SetType setType) {
        this.name = name;
        this.code = code;
        this.releaseDate = releaseDate;
        this.setType = setType;
        this.maxCardNumberInBooster = Integer.MAX_VALUE;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public int getReleaseYear() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getReleaseDate());
        return cal.get(1);
    }

    public ExpansionSet getParentSet() {
        return this.parentSet;
    }

    public SetType getSetType() {
        return this.setType;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public List<SetCardInfo> getSetCardInfo() {
        return this.cards;
    }

    public String toString() {
        return this.name;
    }

    public List<SetCardInfo> findCardInfoByClass(Class<?> clazz) {
        return this.cards.stream().filter(info -> info.getCardClass().equals(clazz)).collect(Collectors.toList());
    }

    public List<Card> create15CardBooster() {
        List<Card> theBooster = this.createBooster();
        if (15 > theBooster.size()) {
            List<CardInfo> commons = this.getCardsByRarity(Rarity.COMMON);
            while (15 > theBooster.size() && !commons.isEmpty()) {
                this.addToBooster(theBooster, commons);
                if (!commons.isEmpty()) continue;
                commons = this.getCardsByRarity(Rarity.COMMON);
            }
        }
        while (theBooster.size() > 15) {
            theBooster.remove(0);
        }
        return theBooster;
    }

    protected void addToBooster(List<Card> booster, List<CardInfo> cards) {
        if (cards.isEmpty()) {
            return;
        }
        CardInfo cardInfo = cards.remove(RandomUtil.nextInt(cards.size()));
        Card card = cardInfo.createCard();
        if (card == null) {
            return;
        }
        booster.add(card);
    }

    public BoosterCollator createCollator() {
        return null;
    }

    public List<Card> createBooster() {
        BoosterCollator collator = this.createCollator();
        if (collator != null) {
            return this.createBoosterUsingCollator(collator);
        }
        for (int i = 0; i < 100; ++i) {
            List<Card> booster = this.tryBooster();
            if (!this.boosterIsValid(booster)) continue;
            return this.addReprints(booster);
        }
        logger.error((Object)String.format("Can't generate valid booster for set [%s - %s]", this.getCode(), this.getName()));
        return this.addReprints(this.tryBooster());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Card> createBoosterUsingCollator(BoosterCollator collator) {
        Map<String, CardInfo> map = this.inBoosterMap;
        synchronized (map) {
            if (this.inBoosterMap.isEmpty()) {
                this.generateBoosterMap();
            }
        }
        return collator.makeBooster().stream().map(this.inBoosterMap::get).map(CardInfo::createCard).collect(Collectors.toList());
    }

    protected void generateBoosterMap() {
        CardRepository.instance.findCards(new CardCriteria().setCodes(this.code)).stream().forEach(cardInfo -> this.inBoosterMap.put(cardInfo.getCardNumber(), (CardInfo)cardInfo));
        if (!this.hasBasicLands && this.parentSet != null) {
            String parentCode = this.parentSet.code;
            CardRepository.instance.findCards(new CardCriteria().setCodes(parentCode).rarities(Rarity.LAND)).stream().forEach(cardInfo -> this.inBoosterMap.put(parentCode + "_" + cardInfo.getCardNumber(), (CardInfo)cardInfo));
        }
    }

    protected boolean boosterIsValid(List<Card> booster) {
        if (!this.validateCommonColors(booster)) {
            return false;
        }
        return this.validateUncommonColors(booster);
    }

    public static ObjectColor getColorForValidate(Card card) {
        FilterMana colorIdentity;
        ObjectColor color = card.getColor();
        if (color.isColorless() && !card.isLand() && (colorIdentity = card.getColorIdentity()).getColorCount() == 1) {
            return new ObjectColor(colorIdentity.toString());
        }
        return color;
    }

    protected boolean validateCommonColors(List<Card> booster) {
        List commonColors = booster.stream().filter(card -> card.getRarity() == Rarity.COMMON).map(ExpansionSet::getColorForValidate).collect(Collectors.toList());
        ObjectColor colorsRepresented = new ObjectColor();
        HashSet<ObjectColor> colorCombinations = new HashSet<ObjectColor>();
        int colorlessCountPlusOne = 1;
        for (ObjectColor color : commonColors) {
            colorCombinations.add(color);
            int colorCount = color.getColorCount();
            if (colorCount == 0) {
                ++colorlessCountPlusOne;
                continue;
            }
            if (colorCount > 1 && !this.hasOnlyMulticolorCards) {
                List<ObjectColor> multiColor = color.getColors();
                colorsRepresented.addColor(multiColor.get(RandomUtil.nextInt(multiColor.size())));
                continue;
            }
            colorsRepresented.addColor(color);
        }
        int colors = Math.min(colorsRepresented.getColorCount(), colorCombinations.size());
        if (colors >= Math.min(5, commonColors.size() - colorlessCountPlusOne)) {
            return true;
        }
        if (colors < 4) {
            return false;
        }
        if (this.hasUnbalancedColors) {
            return true;
        }
        if (commonColors.size() < this.numBoosterCommon) {
            ++colorlessCountPlusOne;
        }
        return RandomUtil.nextDouble() > Math.pow(0.8, colorlessCountPlusOne);
    }

    protected boolean validateUncommonColors(List<Card> booster) {
        List uncommonColors = booster.stream().filter(card -> card.getRarity() == Rarity.UNCOMMON).map(ExpansionSet::getColorForValidate).collect(Collectors.toList());
        if (uncommonColors.size() < 3) {
            return true;
        }
        if (uncommonColors.contains(ObjectColor.COLORLESS)) {
            return true;
        }
        return new HashSet(uncommonColors).size() > 1;
    }

    protected boolean checkMythic() {
        return this.ratioBoosterMythic > 0.0 && this.ratioBoosterMythic * RandomUtil.nextDouble() <= 1.0;
    }

    protected boolean checkSpecialMythic() {
        return this.ratioBoosterSpecialMythic > 0.0 && this.ratioBoosterSpecialMythic * RandomUtil.nextDouble() <= 1.0;
    }

    protected List<Card> tryBooster() {
        ArrayList<Card> booster = new ArrayList<Card>();
        if (!this.hasBoosters) {
            return booster;
        }
        if (this.numBoosterLands > 0) {
            List<CardInfo> specialLands = this.getSpecialCardsByRarity(Rarity.LAND);
            List<CardInfo> basicLands = this.getCardsByRarity(Rarity.LAND);
            for (int i = 0; i < this.numBoosterLands; ++i) {
                if (this.ratioBoosterSpecialLand > 0 && RandomUtil.nextInt(this.ratioBoosterSpecialLand) < this.ratioBoosterSpecialLandNumerator) {
                    this.addToBooster(booster, specialLands);
                    continue;
                }
                this.addToBooster(booster, basicLands);
            }
        }
        int numCommonsToGenerate = this.numBoosterCommon;
        int numSpecialToGenerate = this.numBoosterSpecial;
        if (this.ratioBoosterSpecialCommon > 0 && RandomUtil.nextInt(this.ratioBoosterSpecialCommon) < 1) {
            --numCommonsToGenerate;
            ++numSpecialToGenerate;
        }
        List<CardInfo> commons = this.getCardsByRarity(Rarity.COMMON);
        for (int i = 0; i < numCommonsToGenerate; ++i) {
            this.addToBooster(booster, commons);
        }
        int numUncommonsToGenerate = this.numBoosterUncommon;
        int numRaresToGenerate = this.numBoosterRare;
        if (this.ratioBoosterSpecialRare > 0.0) {
            Rarity specialRarity = Rarity.UNCOMMON;
            if (this.ratioBoosterSpecialRare * RandomUtil.nextDouble() <= 1.0) {
                specialRarity = this.checkSpecialMythic() ? Rarity.MYTHIC : Rarity.RARE;
                --numRaresToGenerate;
            } else {
                --numUncommonsToGenerate;
            }
            this.addToBooster(booster, this.getSpecialCardsByRarity(specialRarity));
        }
        List<CardInfo> uncommons = this.getCardsByRarity(Rarity.UNCOMMON);
        for (int i = 0; i < numUncommonsToGenerate; ++i) {
            this.addToBooster(booster, uncommons);
        }
        if (numRaresToGenerate > 0) {
            List<CardInfo> rares = this.getCardsByRarity(Rarity.RARE);
            List<CardInfo> mythics = this.getCardsByRarity(Rarity.MYTHIC);
            for (int i = 0; i < numRaresToGenerate; ++i) {
                this.addToBooster(booster, this.checkMythic() ? mythics : rares);
            }
        }
        if (this.numBoosterDoubleFaced > 0) {
            this.addDoubleFace(booster);
        }
        if (numSpecialToGenerate > 0) {
            this.addSpecialCards(booster, numSpecialToGenerate);
        }
        return booster;
    }

    protected void addDoubleFace(List<Card> booster) {
        for (int i = 0; i < this.numBoosterDoubleFaced; ++i) {
            int rarityKey = RandomUtil.nextInt(121);
            Rarity rarity = rarityKey < 66 ? Rarity.COMMON : (rarityKey < 108 ? Rarity.UNCOMMON : (rarityKey < 120 ? Rarity.RARE : Rarity.MYTHIC));
            this.addToBooster(booster, this.getSpecialCardsByRarity(rarity));
        }
    }

    protected void addSpecialCards(List<Card> booster, int number) {
        List<CardInfo> specialCards = this.getCardsByRarity(Rarity.SPECIAL);
        for (int i = 0; i < number; ++i) {
            this.addToBooster(booster, specialCards);
        }
    }

    public static Date buildDate(int year, int month, int day) {
        return new GregorianCalendar(year, month - 1, day).getTime();
    }

    public boolean hasBoosters() {
        return this.hasBoosters;
    }

    public boolean hasBasicLands() {
        return this.hasBasicLands;
    }

    public boolean isRotationSet() {
        return this.rotationSet;
    }

    private List<CardInfo> removeReprints(List<CardInfo> list) {
        HashMap usedNames = new HashMap();
        ArrayList<CardInfo> filteredList = new ArrayList<CardInfo>();
        list.forEach(card -> {
            CardInfo foundCard = usedNames.getOrDefault(card.getName(), null);
            if (foundCard == null) {
                usedNames.put(card.getName(), card);
                filteredList.add((CardInfo)card);
            }
        });
        return filteredList;
    }

    private List<Card> addReprints(List<Card> booster) {
        if (booster.stream().noneMatch(MageObject::getUsesVariousArt)) {
            return new ArrayList<Card>(booster);
        }
        if (this.savedReprints == null) {
            this.savedReprints = new HashMap<String, List<CardInfo>>();
            ArrayList<String> needSets = new ArrayList<String>();
            needSets.add(this.code);
            if (this.parentSet != null) {
                needSets.add(this.parentSet.code);
            }
            List<CardInfo> cardInfos = this.hasAlternateBoosterPrintings ? CardRepository.instance.findCards(new CardCriteria().setCodes(needSets).variousArt(true).maxCardNumber(this.maxCardNumberInBooster)) : CardRepository.instance.findCards(new CardCriteria().setCodes(needSets).variousArt(true).maxCardNumber(this.maxCardNumberInBooster).supertypes(SuperType.BASIC));
            cardInfos.forEach(card -> {
                this.savedReprints.putIfAbsent(card.getName(), new ArrayList());
                this.savedReprints.get(card.getName()).add((CardInfo)card);
            });
        }
        ArrayList<Card> finalBooster = new ArrayList<Card>();
        booster.forEach(card -> {
            Card newCard;
            List reprints = this.savedReprints.getOrDefault(card.getName(), null);
            if (reprints != null && reprints.size() > 1 && (newCard = ((CardInfo)reprints.get(RandomUtil.nextInt(reprints.size()))).createCard()) != null) {
                finalBooster.add(newCard);
                return;
            }
            finalBooster.add((Card)card);
        });
        return finalBooster;
    }

    public final synchronized List<CardInfo> getCardsByRarity(Rarity rarity) {
        List<CardInfo> savedCardInfos = this.savedCards.get((Object)rarity);
        if (savedCardInfos == null) {
            savedCardInfos = this.removeReprints(this.findCardsByRarity(rarity));
            this.savedCards.put(rarity, savedCardInfos);
        }
        return new ArrayList<CardInfo>(savedCardInfos);
    }

    public final synchronized List<CardInfo> getSpecialCardsByRarity(Rarity rarity) {
        List<CardInfo> savedCardInfos = this.savedSpecialCards.get((Object)rarity);
        if (savedCardInfos == null) {
            savedCardInfos = this.removeReprints(this.findSpecialCardsByRarity(rarity));
            this.savedSpecialCards.put(rarity, savedCardInfos);
        }
        return new ArrayList<CardInfo>(savedCardInfos);
    }

    protected List<CardInfo> findCardsByRarity(Rarity rarity) {
        if (rarity == Rarity.LAND && !this.hasBasicLands && this.parentSet != null) {
            return this.parentSet.getCardsByRarity(rarity);
        }
        List<CardInfo> cardInfos = CardRepository.instance.findCards(new CardCriteria().setCodes(this.code).rarities(rarity).maxCardNumber(this.maxCardNumberInBooster));
        cardInfos.removeIf(next -> next.getCardNumber().contains("*") || next.getCardNumber().contains("+"));
        List<CardInfo> specialCards = this.getSpecialCardsByRarity(rarity);
        if (rarity == Rarity.COMMON && this.ratioBoosterSpecialLand > 0) {
            specialCards.addAll(this.getSpecialCardsByRarity(Rarity.LAND));
        }
        cardInfos.removeAll(specialCards);
        return cardInfos;
    }

    protected List<CardInfo> findSpecialCardsByRarity(Rarity rarity) {
        ArrayList<CardInfo> cardInfos = new ArrayList<CardInfo>();
        if (rarity == Rarity.LAND && this.ratioBoosterSpecialLand > 0) {
            cardInfos.addAll(CardRepository.instance.findCards(new CardCriteria().setCodes(this.code).rarities(Rarity.COMMON).types(CardType.LAND).maxCardNumber(this.maxCardNumberInBooster)));
        }
        if (this.numBoosterDoubleFaced > 0) {
            cardInfos.addAll(CardRepository.instance.findCards(new CardCriteria().setCodes(this.code).rarities(rarity).doubleFaced(true).maxCardNumber(this.maxCardNumberInBooster)));
        }
        cardInfos.removeIf(next -> next.getCardNumber().contains("*") || next.getCardNumber().contains("+"));
        return cardInfos;
    }

    public int getMaxCardNumberInBooster() {
        return this.maxCardNumberInBooster;
    }

    public int getNumBoosterDoubleFaced() {
        return this.numBoosterDoubleFaced;
    }

    protected static void addCardInfoToList(List<CardInfo> boosterList, String name, String expansion, String cardNumber) {
        CardInfo cardInfo = CardRepository.instance.findCardWithPreferredSetAndNumber(name, expansion, cardNumber);
        if (cardInfo == null || !cardInfo.getSetCode().equals(expansion) || !cardInfo.getCardNumber().equals(cardNumber)) {
            throw new IllegalStateException("CardInfo not found: " + name + " (" + expansion + ":" + cardNumber + ")");
        }
        boosterList.add(cardInfo);
    }

    public void enableDraftBooster(int maxCardNumberInBooster, int land, int common, int uncommon, int rare) {
        this.hasBoosters = true;
        this.maxCardNumberInBooster = maxCardNumberInBooster;
        this.numBoosterLands = land;
        this.hasBasicLands = land > 0;
        this.numBoosterCommon = common;
        this.numBoosterUncommon = uncommon;
        this.numBoosterRare = rare;
        this.ratioBoosterMythic = 8.0;
    }

    public void enableSetBooster(int maxCardNumberInBooster) {
        this.hasBoosters = true;
        this.maxCardNumberInBooster = maxCardNumberInBooster;
        this.hasBasicLands = true;
        this.numBoosterLands = 0;
        this.numBoosterCommon = 0;
        this.numBoosterUncommon = 0;
        this.numBoosterRare = 0;
        ++this.numBoosterCommon;
        ++this.numBoosterLands;
        this.numBoosterCommon += 4;
        this.numBoosterUncommon += 2;
        ++this.numBoosterCommon;
        ++this.numBoosterUncommon;
        ++this.numBoosterRare;
        ++this.numBoosterRare;
        this.ratioBoosterMythic = 8.0;
    }

    public void enablePlayBooster(int maxCardNumberInBooster) {
        this.hasBoosters = true;
        this.maxCardNumberInBooster = maxCardNumberInBooster;
        this.numBoosterCommon = 6;
        ++this.numBoosterCommon;
        this.numBoosterUncommon = 3;
        this.numBoosterRare = 1;
        this.ratioBoosterMythic = 8.0;
        this.hasBasicLands = true;
        this.numBoosterLands = 1;
        ++this.numBoosterUncommon;
        ++this.numBoosterRare;
    }

    public void enableArenaBooster(int maxCardNumberInBooster) {
        this.enablePlayBooster(maxCardNumberInBooster);
    }

    public void enableCollectorBooster(int maxCardNumberInBooster) {
        this.enableCollectorBooster(maxCardNumberInBooster, 1, 5, 4, 5);
    }

    public void enableCollectorBooster(int maxCardNumberInBooster, int land, int common, int uncommon, int rare) {
        this.hasBoosters = true;
        this.maxCardNumberInBooster = maxCardNumberInBooster;
        this.numBoosterLands = land;
        this.hasBasicLands = land > 0;
        this.numBoosterCommon = common;
        this.numBoosterUncommon = uncommon;
        this.numBoosterRare = rare;
        this.ratioBoosterMythic = 8.0;
    }

    private static enum ExpansionSetComparator implements Comparator<ExpansionSet>
    {
        instance;


        @Override
        public int compare(ExpansionSet lhs, ExpansionSet rhs) {
            return lhs.getReleaseDate().after(rhs.getReleaseDate()) ? -1 : 1;
        }
    }

    public static class SetCardInfo
    implements Serializable {
        private final String name;
        private final String cardNumber;
        private final Rarity rarity;
        private final Class<?> cardClass;
        private final CardGraphicInfo graphicInfo;

        public SetCardInfo(String name, int cardNumber, Rarity rarity, Class<?> cardClass) {
            this(name, String.valueOf(cardNumber), rarity, cardClass, null);
        }

        public SetCardInfo(String name, String cardNumber, Rarity rarity, Class<?> cardClass) {
            this(name, cardNumber, rarity, cardClass, null);
        }

        public SetCardInfo(String name, int cardNumber, Rarity rarity, Class<?> cardClass, CardGraphicInfo graphicInfo) {
            this(name, String.valueOf(cardNumber), rarity, cardClass, graphicInfo);
        }

        public SetCardInfo(String name, String cardNumber, Rarity rarity, Class<?> cardClass, CardGraphicInfo graphicInfo) {
            this.name = name;
            this.cardNumber = cardNumber;
            this.rarity = rarity;
            this.cardClass = cardClass;
            this.graphicInfo = graphicInfo;
        }

        public String getName() {
            return this.name;
        }

        public String getCardNumber() {
            return this.cardNumber;
        }

        public int getCardNumberAsInt() {
            return CardUtil.parseCardNumberAsInt(this.cardNumber);
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        public Class<?> getCardClass() {
            return this.cardClass;
        }

        public CardGraphicInfo getGraphicInfo() {
            return this.graphicInfo;
        }

        public boolean isFullArt() {
            return this.graphicInfo != null && this.graphicInfo.getFrameStyle() != null && this.graphicInfo.getFrameStyle().isFullArt();
        }

        public boolean isRetroFrame() {
            return this.graphicInfo != null && this.graphicInfo.getFrameStyle() != null && (this.graphicInfo.getFrameStyle() == FrameStyle.RETRO || this.graphicInfo.getFrameStyle() == FrameStyle.LEA_ORIGINAL_DUAL_LAND_ART_BASIC || this.graphicInfo.getFrameStyle() == FrameStyle.UGL_FULL_ART_BASIC);
        }
    }
}

