/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.constants.CardType;
import mage.constants.SpellAbilityType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.game.Game;

public class ModalDoubleFacedCardHalfImpl
extends CardImpl
implements ModalDoubleFacedCardHalf {
    ModalDoubleFacedCard parentCard;

    public ModalDoubleFacedCardHalfImpl(UUID ownerId, CardSetInfo setInfo, SuperType[] cardSuperTypes, CardType[] cardTypes, SubType[] cardSubTypes, String costs, ModalDoubleFacedCard parentCard, SpellAbilityType spellAbilityType) {
        super(ownerId, setInfo, cardTypes, costs, spellAbilityType);
        this.supertype.addAll(Arrays.asList(cardSuperTypes));
        this.subtype.addAll(Arrays.asList(cardSubTypes));
        this.parentCard = parentCard;
    }

    protected ModalDoubleFacedCardHalfImpl(ModalDoubleFacedCardHalfImpl card) {
        super(card);
        this.parentCard = card.parentCard;
    }

    @Override
    public UUID getOwnerId() {
        return this.parentCard.getOwnerId();
    }

    @Override
    public String getExpansionSetCode() {
        return this.parentCard.getExpansionSetCode();
    }

    @Override
    public String getCardNumber() {
        return this.parentCard.getCardNumber();
    }

    @Override
    public boolean moveToZone(Zone toZone, Ability source, Game game, boolean flag, List<UUID> appliedEffects) {
        return this.parentCard.moveToZone(toZone, source, game, flag, appliedEffects);
    }

    @Override
    public boolean moveToExile(UUID exileId, String name, Ability source, Game game, List<UUID> appliedEffects) {
        return this.parentCard.moveToExile(exileId, name, source, game, appliedEffects);
    }

    @Override
    public boolean removeFromZone(Game game, Zone fromZone, Ability source) {
        return this.parentCard.removeFromZone(game, fromZone, source);
    }

    @Override
    public ModalDoubleFacedCard getMainCard() {
        return this.parentCard;
    }

    @Override
    public void setZone(Zone zone, Game game) {
        ModalDoubleFacedCardHalf otherSide;
        game.setZone(this.parentCard.getId(), zone);
        game.setZone(this.getId(), zone);
        if (!this.parentCard.getLeftHalfCard().getId().equals(this.getId())) {
            otherSide = this.parentCard.getLeftHalfCard();
        } else if (!this.parentCard.getRightHalfCard().getId().equals(this.getId())) {
            otherSide = this.parentCard.getRightHalfCard();
        } else {
            throw new IllegalStateException("Wrong code usage: MDF halves must use different ids");
        }
        switch (zone) {
            case STACK: 
            case BATTLEFIELD: {
                game.setZone(otherSide.getId(), Zone.OUTSIDE);
                break;
            }
            default: {
                game.setZone(otherSide.getId(), zone);
            }
        }
        ModalDoubleFacedCard.checkGoodZones(game, this.parentCard);
    }

    @Override
    public ModalDoubleFacedCardHalfImpl copy() {
        return new ModalDoubleFacedCardHalfImpl(this);
    }

    @Override
    public void setParentCard(ModalDoubleFacedCard card) {
        this.parentCard = card;
    }

    @Override
    public ModalDoubleFacedCard getParentCard() {
        return this.parentCard;
    }

    @Override
    public void setPT(int power, int toughness) {
        this.setPT(new MageInt(power), new MageInt(toughness));
    }

    @Override
    public void setPT(MageInt power, MageInt toughness) {
        this.power = power;
        this.toughness = toughness;
    }

    @Override
    public String getIdName() {
        return this.getName() + " [" + this.parentCard.getId().toString().substring(0, 3) + ']';
    }
}

