/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.CardWithSpellOption;
import mage.cards.OmenCard;
import mage.cards.OmenCardSpellAbility;
import mage.cards.SpellOptionCard;
import mage.constants.CardType;
import mage.constants.SpellAbilityType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;

public class OmenSpellCard
extends CardImpl
implements SpellOptionCard {
    private OmenCard omenCardParent;

    public OmenSpellCard(UUID ownerId, CardSetInfo setInfo, String omenName, CardType[] cardTypes, String costs, OmenCard omenCard) {
        super(ownerId, setInfo, cardTypes, costs, SpellAbilityType.OMEN_SPELL);
        this.subtype.add(SubType.OMEN);
        OmenCardSpellAbility newSpellAbility = new OmenCardSpellAbility(this.getSpellAbility(), omenName, cardTypes, costs);
        this.replaceSpellAbility(newSpellAbility);
        this.spellAbility = newSpellAbility;
        this.setName(omenName);
        this.omenCardParent = omenCard;
    }

    @Override
    public void finalizeSpell() {
        if (this.spellAbility instanceof OmenCardSpellAbility) {
            ((OmenCardSpellAbility)this.spellAbility).finalizeOmen();
        }
    }

    protected OmenSpellCard(OmenSpellCard card) {
        super(card);
        this.omenCardParent = card.omenCardParent;
    }

    @Override
    public UUID getOwnerId() {
        return this.omenCardParent.getOwnerId();
    }

    @Override
    public String getExpansionSetCode() {
        return this.omenCardParent.getExpansionSetCode();
    }

    @Override
    public String getCardNumber() {
        return this.omenCardParent.getCardNumber();
    }

    @Override
    public boolean moveToZone(Zone toZone, Ability source, Game game, boolean flag, List<UUID> appliedEffects) {
        return this.omenCardParent.moveToZone(toZone, source, game, flag, appliedEffects);
    }

    @Override
    public boolean moveToExile(UUID exileId, String name, Ability source, Game game, List<UUID> appliedEffects) {
        return this.omenCardParent.moveToExile(exileId, name, source, game, appliedEffects);
    }

    @Override
    public OmenCard getMainCard() {
        return this.omenCardParent;
    }

    @Override
    public void setZone(Zone zone, Game game) {
        game.setZone(this.omenCardParent.getId(), zone);
        game.setZone(this.omenCardParent.getSpellCard().getId(), zone);
    }

    @Override
    public OmenSpellCard copy() {
        return new OmenSpellCard(this);
    }

    @Override
    public void setParentCard(CardWithSpellOption card) {
        this.omenCardParent = (OmenCard)card;
    }

    @Override
    public OmenCard getParentCard() {
        return this.omenCardParent;
    }

    @Override
    public String getIdName() {
        return this.getName() + " [" + this.omenCardParent.getId().toString().substring(0, 3) + ']';
    }

    @Override
    public String getSpellType() {
        return "Omen";
    }
}

