/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.swing.filechooser.FileFilter;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.exporter.DeckExporter;
import mage.cards.decks.exporter.MtgArenaDeckExporter;
import mage.cards.decks.exporter.MtgOnlineDeckExporter;
import mage.cards.decks.exporter.XmageDeckExporter;
import mage.cards.decks.exporter.XmageInfoDeckExporter;

public enum DeckFormats {
    XMAGE(new XmageDeckExporter()),
    XMAGE_INFO(new XmageInfoDeckExporter()),
    MTG_ONLINE(new MtgOnlineDeckExporter()),
    MTG_ARENA(new MtgArenaDeckExporter());

    private final DeckExporter exporter;

    private DeckFormats(DeckExporter exporter) {
        this.exporter = exporter;
    }

    public DeckExporter getExporter() {
        return this.exporter;
    }

    public static Optional<DeckFormats> getFormatForExtension(String filename) {
        String exp = DeckFormats.getExtension(filename).orElse("");
        for (DeckFormats df : DeckFormats.values()) {
            if (exp.isEmpty() || !df.getExporter().getDefaultFileExt().equals(exp)) continue;
            return Optional.of(df);
        }
        return Optional.empty();
    }

    public static Optional<String> getExtension(String filename) {
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < filename.length() - 1) {
            return Optional.of(filename.substring(i + 1).toLowerCase(Locale.ENGLISH));
        }
        return Optional.empty();
    }

    public static Optional<DeckFormats> getFormatForFilter(FileFilter filter) {
        for (DeckFormats df : DeckFormats.values()) {
            if (!df.getExporter().getFileFilter().equals(filter)) continue;
            return Optional.of(df);
        }
        return Optional.empty();
    }

    public static String getDefaultFileExtForFilter(FileFilter filter) {
        return DeckFormats.getFormatForFilter(filter).map(df -> df.getExporter().getDefaultFileExt()).orElse("");
    }

    public static List<FileFilter> getFileFilters() {
        ArrayList<FileFilter> res = new ArrayList<FileFilter>();
        for (DeckFormats df : DeckFormats.values()) {
            res.add(df.getExporter().getFileFilter());
        }
        return res;
    }

    public static void writeDeck(String file, DeckCardLists deck) throws IOException {
        DeckFormats.writeDeck(new File(file), deck);
    }

    public static void writeDeck(String file, DeckCardLists deck, DeckFormats format) throws IOException {
        DeckFormats.writeDeck(new File(file), deck, format);
    }

    public static void writeDeck(String file, DeckCardLists deck, DeckExporter exporter) throws IOException {
        DeckFormats.writeDeck(new File(file), deck, exporter);
    }

    public static void writeDeck(File file, DeckCardLists deck) throws IOException {
        DeckFormats format = DeckFormats.getFormatForExtension(file.getName()).orElseGet(() -> {
            throw new IllegalArgumentException("Could not determine deck export format.");
        });
        DeckFormats.writeDeck(file, deck, format);
    }

    public static void writeDeck(File file, DeckCardLists deck, DeckFormats format) throws IOException {
        DeckFormats.writeDeck(file, deck, format.getExporter());
    }

    public static void writeDeck(File file, DeckCardLists deck, DeckExporter exporter) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            DeckFormats.writeDeck((OutputStream)out, deck, exporter);
        }
    }

    public static void writeDeck(OutputStream out, DeckCardLists deck, DeckFormats format) {
        DeckFormats.writeDeck(new PrintWriter(out), deck, format);
    }

    public static void writeDeck(OutputStream out, DeckCardLists deck, DeckExporter exporter) {
        DeckFormats.writeDeck(new PrintWriter(out), deck, exporter);
    }

    public static void writeDeck(PrintWriter out, DeckCardLists deck, DeckFormats format) {
        DeckFormats.writeDeck(out, deck, format.getExporter());
    }

    public static void writeDeck(PrintWriter out, DeckCardLists deck, DeckExporter exporter) {
        exporter.writeDeck(out, deck);
        out.flush();
    }
}

