/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mage.cards.Card;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckValidatorError;
import mage.cards.decks.DeckValidatorErrorType;

public abstract class DeckValidator
implements Serializable {
    public static final Set<String> MAIN_BASIC_LAND_NAMES = new HashSet<String>(Arrays.asList("Plains", "Island", "Swamp", "Mountain", "Forest"));
    public static final Set<String> ADDITIONAL_BASIC_LAND_NAMES = new HashSet<String>(Arrays.asList("Wastes", "Snow-Covered Plains", "Snow-Covered Island", "Snow-Covered Swamp", "Snow-Covered Mountain", "Snow-Covered Forest", "Snow-Covered Wastes"));
    public static final Set<String> ALL_BASIC_LAND_NAMES = new HashSet<String>();
    protected static final Map<String, Integer> maxCopiesMap;
    protected String name;
    protected String shortName;
    protected List<DeckValidatorError> errorsList = new ArrayList<DeckValidatorError>();

    protected DeckValidator(String name, String shortName) {
        this.setName(name, shortName);
    }

    public abstract boolean validate(Deck var1);

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    protected void setName(String name, String shortName) {
        this.name = name;
        this.shortName = shortName != null ? shortName : (name.contains("-") ? name.substring(name.indexOf("-") + 1).trim() : name);
    }

    protected void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public List<DeckValidatorError> getErrorsList() {
        return this.errorsList;
    }

    public List<DeckValidatorError> getErrorsListSorted() {
        return this.getErrorsListSorted(Integer.MAX_VALUE);
    }

    public List<DeckValidatorError> getErrorsListSorted(int maxErrors) {
        List<DeckValidatorError> list = new ArrayList<DeckValidatorError>(this.getErrorsList());
        list.sort((e1, e2) -> {
            Integer order2;
            int res = 0;
            Integer order1 = e1.getErrorType().getSortOrder();
            res = order1.compareTo(order2 = Integer.valueOf(e2.getErrorType().getSortOrder()));
            if (res == 0) {
                res = e1.getGroup().compareTo(e2.getGroup());
            }
            if (res == 0) {
                res = e1.getMessage().compareTo(e2.getMessage());
            }
            return res;
        });
        if (list.size() <= maxErrors) {
            return list;
        }
        int otherErrorsCount = list.size() - maxErrors;
        list = list.stream().limit(maxErrors).collect(Collectors.toList());
        list.add(new DeckValidatorError(DeckValidatorErrorType.OTHER, "...", "and more " + otherErrorsCount + " error" + (otherErrorsCount > 1 ? "s" : ""), null));
        return list;
    }

    public String getErrorsListInfo() {
        return this.errorsList.stream().map(e -> e.getGroup() + "=" + e.getMessage()).collect(Collectors.joining(", "));
    }

    public void addError(DeckValidatorErrorType errorType, String group, String message, boolean isCardError) {
        this.addError(errorType, group, message, isCardError ? group : null);
    }

    public void addError(DeckValidatorErrorType errorType, String group, String message) {
        this.addError(errorType, group, message, null);
    }

    private void addError(DeckValidatorErrorType errorType, String group, String message, String cardName) {
        this.errorsList.add(new DeckValidatorError(errorType, group, message, cardName));
    }

    public boolean errorsListContainsGroup(String group) {
        return this.errorsList.stream().anyMatch(e -> e.getGroup().equals(group));
    }

    public boolean isPartlyValid() {
        return this.errorsList.isEmpty() || this.errorsList.stream().allMatch(e -> e.getErrorType().isPartlyLegal());
    }

    protected void countCards(Map<String, Integer> counts, Collection<Card> cards) {
        for (Card card : cards) {
            if (counts.containsKey(card.getName())) {
                counts.put(card.getName(), counts.get(card.getName()) + 1);
                continue;
            }
            counts.put(card.getName(), 1);
        }
    }

    public int getEdhPowerLevel(Deck deck, List<String> foundPowerCards, List<String> foundInfo) {
        return 0;
    }

    public abstract int getDeckMinSize();

    public abstract int getSideboardMinSize();

    protected static int getMaxCopies(String name, int defaultAmount) {
        return maxCopiesMap.getOrDefault(name, defaultAmount);
    }

    static {
        ALL_BASIC_LAND_NAMES.addAll(MAIN_BASIC_LAND_NAMES);
        ALL_BASIC_LAND_NAMES.addAll(ADDITIONAL_BASIC_LAND_NAMES);
        maxCopiesMap = new HashMap<String, Integer>();
        MAIN_BASIC_LAND_NAMES.forEach(s -> maxCopiesMap.put((String)s, Integer.MAX_VALUE));
        ADDITIONAL_BASIC_LAND_NAMES.forEach(s -> maxCopiesMap.put((String)s, Integer.MAX_VALUE));
        maxCopiesMap.put("Relentless Rats", Integer.MAX_VALUE);
        maxCopiesMap.put("Shadowborn Apostle", Integer.MAX_VALUE);
        maxCopiesMap.put("Rat Colony", Integer.MAX_VALUE);
        maxCopiesMap.put("Persistent Petitioners", Integer.MAX_VALUE);
        maxCopiesMap.put("Dragon's Approach", Integer.MAX_VALUE);
        maxCopiesMap.put("Slime Against Humanity", Integer.MAX_VALUE);
        maxCopiesMap.put("Templar Knight", Integer.MAX_VALUE);
        maxCopiesMap.put("Hare Apparent", Integer.MAX_VALUE);
        maxCopiesMap.put("Tempest Hawk", Integer.MAX_VALUE);
        maxCopiesMap.put("Cid, Timeless Artificer", Integer.MAX_VALUE);
        maxCopiesMap.put("Once More with Feeling", 1);
        maxCopiesMap.put("Seven Dwarves", 7);
        maxCopiesMap.put("Nazgul", 9);
    }
}

