/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.log4j.Logger;

public class DnDDeckTargetListener
extends DropTargetAdapter {
    private static final transient Logger logger = Logger.getLogger(DnDDeckTargetListener.class);
    private static final DataFlavor fileFlavor = DataFlavor.javaFileListFlavor;
    private static final DataFlavor plainTextFlavor = DataFlavor.stringFlavor;

    private boolean isCopyOrMove(int dropAction) {
        return (dropAction & 3) != 0;
    }

    private boolean isCopyAction(int dropAction) {
        return (dropAction & 1) != 0;
    }

    private boolean isMoveAction(int dropAction) {
        return (dropAction & 2) != 0;
    }

    private boolean isAcceptable(DropTargetDragEvent dtde) {
        boolean copyOrMove = this.isCopyOrMove(dtde.getDropAction());
        boolean flavorSupported = dtde.isDataFlavorSupported(plainTextFlavor) || dtde.isDataFlavorSupported(fileFlavor);
        return copyOrMove && flavorSupported;
    }

    private boolean isAcceptable(DropTargetDropEvent dtde) {
        boolean copyOrMove = this.isCopyOrMove(dtde.getDropAction());
        boolean flavorSupported = dtde.isDataFlavorSupported(plainTextFlavor) || dtde.isDataFlavorSupported(fileFlavor);
        return copyOrMove && flavorSupported;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.isAcceptable(dtde)) {
            dtde.acceptDrag(1);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.isAcceptable(dtde)) {
            dtde.acceptDrag(1);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        if (this.isAcceptable(dtde)) {
            dtde.acceptDrag(1);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (!this.isAcceptable(dtde)) {
            dtde.rejectDrop();
            dtde.dropComplete(false);
            return;
        }
        dtde.acceptDrop(1);
        boolean move = this.isMoveAction(dtde.getDropAction());
        try {
            if (dtde.isDataFlavorSupported(fileFlavor)) {
                List files = (List)dtde.getTransferable().getTransferData(fileFlavor);
                dtde.dropComplete(this.handleFilesDrop(move, files));
            } else if (dtde.isDataFlavorSupported(plainTextFlavor)) {
                String text = (String)dtde.getTransferable().getTransferData(plainTextFlavor);
                try {
                    dtde.dropComplete(this.handleUriDrop(move, new URI(text)));
                }
                catch (URISyntaxException e) {
                    dtde.dropComplete(this.handlePlainTextDrop(move, text));
                }
            }
        }
        catch (UnsupportedFlavorException | IOException e) {
            logger.error((Object)"Unsupported drag and drop data", (Throwable)e);
            dtde.dropComplete(false);
        }
    }

    protected boolean handlePlainTextDrop(boolean move, String text) {
        return false;
    }

    protected boolean handleUriDrop(boolean move, URI uri) {
        return false;
    }

    protected boolean handleFilesDrop(boolean move, List<File> files) {
        return false;
    }
}

