/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks.importer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mage.cards.decks.CardNameUtil;
import mage.cards.decks.DeckCardInfo;
import mage.cards.decks.DeckCardLayout;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.importer.DeckImporter;
import mage.cards.decks.importer.PlainTextDeckImporter;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;

public class DckDeckImporter
extends PlainTextDeckImporter {
    private static final Pattern pattern = Pattern.compile("(SB:)?\\s*(\\d*)\\s*\\[([^]:]+):([^]:]+)\\]\\s*(.*)\\s*$");
    private static final Pattern layoutPattern = Pattern.compile("LAYOUT (\\w+):\\((\\d+),(\\d+)\\)([^|]+)\\|(.*)$");
    private static final Pattern layoutStackPattern = Pattern.compile("\\(([^)]*)\\)");
    private static final Pattern layoutStackEntryPattern = Pattern.compile("\\[(\\w+[^:]*\\w*):(\\w+\\w*)]");
    private final Map<String, String> possibleFixes = new LinkedHashMap<String, String>();

    @Override
    protected void readLine(String line, DeckCardLists deckList, DeckImporter.FixedInfo fixedInfo) {
        if (line.isEmpty() || line.startsWith("#")) {
            return;
        }
        line = CardNameUtil.normalizeCardName(line);
        for (Map.Entry<String, String> fix : this.possibleFixes.entrySet()) {
            if (!line.contains(fix.getKey())) continue;
            line = line.replace(fix.getKey(), fix.getValue());
        }
        fixedInfo.setFixedLine(line);
        Matcher m = pattern.matcher(line);
        if (m.matches()) {
            boolean sideboard = false;
            if ("SB:".equals(m.group(1))) {
                sideboard = true;
            }
            int count = Integer.parseInt(m.group(2));
            String setCode = m.group(3);
            String cardNum = m.group(4);
            String cardName = m.group(5);
            DeckCardInfo.makeSureCardAmountFine(count, cardName);
            cardNum = cardNum == null ? "" : cardNum.trim();
            setCode = setCode == null ? "" : setCode.trim();
            cardName = cardName == null ? "" : cardName.trim();
            String originalNumbers = "";
            String originalNumbersWithName = "";
            if (!setCode.isEmpty() && !cardNum.isEmpty()) {
                originalNumbers = "[" + setCode + ":" + cardNum + "]";
                originalNumbersWithName = originalNumbers + " " + cardName;
            }
            DeckCardInfo deckCardInfo = null;
            CardInfo foundedCard = CardRepository.instance.findCard(setCode, cardNum, true);
            boolean wasOutdated = false;
            if (foundedCard != null && !foundedCard.getName().equals(cardName)) {
                this.sbMessage.append("Line ").append(this.lineCount).append(": ").append("found outdated card number or name, will try to replace: ").append(line).append('\n');
                wasOutdated = true;
                foundedCard = null;
            }
            if (foundedCard == null) {
                if (!wasOutdated) {
                    this.sbMessage.append("Line ").append(this.lineCount).append(": ").append("can't find card by number, will try to replace: ").append(line).append('\n');
                }
                if (!cardName.equals("")) {
                    foundedCard = CardRepository.instance.findPreferredCoreExpansionCard(cardName, setCode);
                }
                if (foundedCard != null) {
                    if (foundedCard.isNightCard()) {
                        this.sbMessage.append("Line ").append(this.lineCount).append(": ").append("ERROR, you can't use night card in deck [").append(foundedCard.getName()).append("]").append('\n');
                    } else {
                        this.sbMessage.append("Line ").append(this.lineCount).append(": ").append("replaced to [").append(foundedCard.getSetCode()).append(":").append(foundedCard.getCardNumberAsInt()).append("] ").append(foundedCard.getName()).append('\n');
                        String fixNumbers = "[" + foundedCard.getSetCode() + ":" + foundedCard.getCardNumber() + "]";
                        String fixNumbersWithName = fixNumbers + " " + foundedCard.getName();
                        this.possibleFixes.put(originalNumbersWithName, fixNumbersWithName);
                        this.possibleFixes.put(originalNumbers, fixNumbers);
                        String fixedLine = fixedInfo.getOriginalLine().replace(originalNumbersWithName, fixNumbersWithName).replace(originalNumbers, fixNumbers);
                        fixedInfo.setFixedLine(fixedLine);
                    }
                } else {
                    this.sbMessage.append("Line ").append(this.lineCount).append(": ").append("ERROR, can't find card [").append(cardName).append("]").append('\n');
                }
            }
            if (foundedCard != null) {
                deckCardInfo = new DeckCardInfo(foundedCard.getName(), foundedCard.getCardNumber(), foundedCard.getSetCode());
            }
            if (deckCardInfo != null) {
                for (int i = 0; i < count; ++i) {
                    if (!sideboard) {
                        deckList.getCards().add(deckCardInfo.copy());
                        continue;
                    }
                    deckList.getSideboard().add(deckCardInfo.copy());
                }
            }
        } else if (line.startsWith("NAME:")) {
            deckList.setName(line.substring(5));
        } else if (line.startsWith("AUTHOR:")) {
            deckList.setAuthor(line.substring(7));
        } else if (line.startsWith("LAYOUT")) {
            Matcher m2 = layoutPattern.matcher(line);
            if (m2.find()) {
                String target = m2.group(1);
                int rows = Integer.parseInt(m2.group(2));
                int cols = Integer.parseInt(m2.group(3));
                String settings = m2.group(4);
                String stackData = m2.group(5);
                Matcher stackMatcher = layoutStackPattern.matcher(stackData);
                ArrayList<List<List<DeckCardInfo>>> grid = new ArrayList<List<List<DeckCardInfo>>>();
                int totalCardCount = 0;
                for (int row = 0; row < rows; ++row) {
                    ArrayList rowData = new ArrayList();
                    grid.add(rowData);
                    for (int col = 0; col < cols; ++col) {
                        ArrayList<DeckCardInfo> stack = new ArrayList<DeckCardInfo>();
                        rowData.add(stack);
                        if (stackMatcher.find()) {
                            String thisStackData = stackMatcher.group(1);
                            Matcher stackEntries = layoutStackEntryPattern.matcher(thisStackData);
                            while (stackEntries.find()) {
                                ++totalCardCount;
                                stack.add(new DeckCardInfo("", stackEntries.group(2), stackEntries.group(1)));
                            }
                            continue;
                        }
                        this.sbMessage.append("Missing stack\n.");
                    }
                }
                DeckCardLayout layout = new DeckCardLayout(grid, settings);
                int expectedCount = 0;
                switch (target) {
                    case "MAIN": {
                        deckList.setCardLayout(layout);
                        expectedCount = deckList.getCards().size();
                        break;
                    }
                    case "SIDEBOARD": {
                        deckList.setSideboardLayout(layout);
                        expectedCount = deckList.getSideboard().size();
                        break;
                    }
                    default: {
                        this.sbMessage.append("Bad target `").append(target).append("` for layout.\n");
                    }
                }
                if (totalCardCount != expectedCount) {
                    this.sbMessage.append("Layout mismatch: Expected ").append(expectedCount).append(" cards, but got ").append(totalCardCount).append(" in layout `").append(target).append("`\n.");
                }
            } else {
                this.sbMessage.append("Malformed layout line");
            }
        }
    }
}

