/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks.importer;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mage.cards.decks.DeckCardInfo;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.importer.CardLookup;
import mage.cards.decks.importer.XmlDeckImporter;
import mage.cards.repository.CardInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class O8dDeckImporter
extends XmlDeckImporter {
    @Override
    public DeckCardLists importDeck(String fileName, StringBuilder errorMessages, boolean saveAutoFixedFile) {
        try {
            Document doc = this.getXmlDocument(fileName);
            DeckCardLists decklist = new DeckCardLists();
            List<Node> mainCards = this.getNodes(doc, "/deck/section[@name='Main']/card");
            decklist.setCards(mainCards.stream().flatMap(O8dDeckImporter.toDeckCardInfo(this.getCardLookup(), errorMessages)).collect(Collectors.toList()));
            List<Node> sideboardCards = this.getNodes(doc, "/deck/section[@name='Sideboard']/card");
            decklist.setSideboard(sideboardCards.stream().flatMap(O8dDeckImporter.toDeckCardInfo(this.getCardLookup(), errorMessages)).collect(Collectors.toList()));
            return decklist;
        }
        catch (Exception e) {
            logger.error((Object)"Error loading deck", (Throwable)e);
            errorMessages.append("There was an error loading the deck.");
            return new DeckCardLists();
        }
    }

    private static int getQuantityFromNode(Node node) {
        Node numberNode = node.getAttributes().getNamedItem("qty");
        if (numberNode == null) {
            return 1;
        }
        try {
            return Math.min(100, Math.max(1, Integer.parseInt(numberNode.getNodeValue())));
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    private static Function<Node, Stream<DeckCardInfo>> toDeckCardInfo(CardLookup lookup, StringBuilder errors) {
        return node -> {
            String name = node.getTextContent();
            CardInfo cardInfo = lookup.lookupCardInfo(name);
            if (cardInfo != null) {
                return Collections.nCopies(O8dDeckImporter.getQuantityFromNode(node), new DeckCardInfo(cardInfo.getName(), cardInfo.getCardNumber(), cardInfo.getSetCode())).stream();
            }
            errors.append("Could not find card: '").append(name).append("'\n");
            return Stream.empty();
        };
    }
}

