/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.mock;

import java.util.ArrayList;
import java.util.List;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.cards.CardImpl;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.mock.MockAbility;
import mage.cards.mock.MockableCard;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.util.CardUtil;

public class MockCard
extends CardImpl
implements MockableCard {
    public static String CARD_WITH_SPELL_OPTION_NAME_SEPARATOR = " // ";
    public static String MODAL_DOUBLE_FACES_NAME_SEPARATOR = " // ";
    private final int startingLoyalty;
    private final int startingDefense;
    protected List<String> manaCostLeftStr;
    protected List<String> manaCostRightStr;
    protected List<String> manaCostStr;
    protected String spellOptionName;
    protected boolean isModalDoubleFacedCard;
    protected int manaValue;

    public MockCard(CardInfo card) {
        super(null, card.getName());
        this.setExpansionSetCode(card.getSetCode());
        this.setUsesVariousArt(card.usesVariousArt());
        this.setCardNumber(card.getCardNumber());
        this.setImageFileName("");
        this.setImageNumber(0);
        this.power = this.mageIntFromString(card.getPower());
        this.toughness = this.mageIntFromString(card.getToughness());
        this.rarity = card.getRarity();
        this.cardType = card.getTypes();
        this.subtype = card.getSubTypes();
        this.supertype = card.getSupertypes();
        this.manaCostLeftStr = card.getManaCosts(CardInfo.ManaCostSide.LEFT);
        this.manaCostRightStr = card.getManaCosts(CardInfo.ManaCostSide.RIGHT);
        this.manaCostStr = card.getManaCosts(CardInfo.ManaCostSide.ALL);
        this.manaValue = card.getManaValue();
        this.color = card.getColor();
        this.frameColor = card.getFrameColor();
        this.frameStyle = card.getFrameStyle();
        this.flipCard = card.isFlipCard();
        this.nightCard = card.isNightCard();
        if (card.getSecondSideName() != null && !card.getSecondSideName().isEmpty()) {
            this.secondSideCard = new MockCard(CardRepository.instance.findCardWithPreferredSetAndNumber(card.getSecondSideName(), card.getSetCode(), card.getCardNumber()));
        }
        if (card.isCardWithSpellOption()) {
            this.spellOptionName = card.getSpellOptionCardName();
        }
        if (card.isModalDoubleFacedCard()) {
            ModalDoubleFacedCard mdfCard = (ModalDoubleFacedCard)card.createCard();
            CardInfo mdfSecondSide = new CardInfo(mdfCard.getRightHalfCard());
            this.secondSideCard = new MockCard(mdfSecondSide);
            this.isModalDoubleFacedCard = true;
        }
        this.startingLoyalty = CardUtil.convertLoyaltyOrDefense(card.getStartingLoyalty());
        this.startingDefense = CardUtil.convertLoyaltyOrDefense(card.getStartingDefense());
        this.flipCardName = card.getFlipCardName();
        for (String ruleText : card.getRules()) {
            this.addAbility(this.textAbilityFromString(ruleText));
        }
        this.extraDeckCard = card.isExtraDeckCard();
    }

    protected MockCard(MockCard card) {
        super(card);
        this.startingLoyalty = card.startingLoyalty;
        this.startingDefense = card.startingDefense;
        this.manaCostLeftStr = new ArrayList<String>(card.manaCostLeftStr);
        this.manaCostRightStr = new ArrayList<String>(card.manaCostRightStr);
        this.manaCostStr = new ArrayList<String>(card.manaCostStr);
        this.spellOptionName = card.spellOptionName;
        this.isModalDoubleFacedCard = card.isModalDoubleFacedCard;
        this.manaValue = card.manaValue;
    }

    @Override
    public int getStartingLoyalty() {
        return this.startingLoyalty;
    }

    @Override
    public int getStartingDefense() {
        return this.startingDefense;
    }

    @Override
    public MockCard copy() {
        return new MockCard(this);
    }

    @Override
    public ManaCosts<ManaCost> getManaCost() {
        throw new IllegalArgumentException("Unsupport method call: getManaCost in " + this.getClass().getCanonicalName());
    }

    @Override
    public List<String> getManaCostSymbols() {
        return this.getManaCostStr(CardInfo.ManaCostSide.ALL);
    }

    @Override
    public int getManaValue() {
        return this.manaValue;
    }

    public List<String> getManaCostStr(CardInfo.ManaCostSide manaCostSide) {
        switch (manaCostSide) {
            case LEFT: {
                return this.manaCostLeftStr;
            }
            case RIGHT: {
                return this.manaCostRightStr;
            }
        }
        return this.manaCostStr;
    }

    public String getFullName(boolean showSecondName) {
        if (!showSecondName) {
            return this.getName();
        }
        if (this.spellOptionName != null) {
            return this.getName() + CARD_WITH_SPELL_OPTION_NAME_SEPARATOR + this.spellOptionName;
        }
        if (this.isModalDoubleFacedCard) {
            return this.getName() + MODAL_DOUBLE_FACES_NAME_SEPARATOR + this.getSecondCardFace().getName();
        }
        return this.getName();
    }

    private MageInt mageIntFromString(String value) {
        try {
            int intValue = Integer.parseInt(value);
            return new MageInt(intValue);
        }
        catch (NumberFormatException e) {
            return new MageInt(0, value);
        }
    }

    private Ability textAbilityFromString(String text) {
        return new MockAbility(text);
    }

    @Override
    public boolean isTransformable() {
        return super.isTransformable() || this.isModalDoubleFacedCard || this.secondSideCard != null;
    }
}

