/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.mock;

import java.util.ArrayList;
import java.util.List;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.cards.SplitCard;
import mage.cards.SplitCardHalf;
import mage.cards.mock.MockCard;
import mage.cards.repository.CardInfo;

public class MockSplitCardHalf
extends MockCard
implements SplitCardHalf {
    private SplitCard splitCardParent;
    private ManaCosts<ManaCost> manaCosts;
    private List<String> manaCostsSymbols;

    public MockSplitCardHalf(CardInfo card) {
        super(card);
        this.manaCostsSymbols = card.getManaCosts(CardInfo.ManaCostSide.ALL);
        this.manaCosts = new ManaCostsImpl<ManaCost>(String.join((CharSequence)"", this.manaCostsSymbols));
    }

    protected MockSplitCardHalf(MockSplitCardHalf card) {
        super(card);
        this.splitCardParent = card.splitCardParent;
        this.manaCosts = card.manaCosts.copy();
        this.manaCostsSymbols = new ArrayList<String>(card.manaCostsSymbols);
    }

    @Override
    public MockSplitCardHalf copy() {
        return new MockSplitCardHalf(this);
    }

    @Override
    public void setParentCard(SplitCard card) {
        this.splitCardParent = card;
    }

    @Override
    public SplitCard getParentCard() {
        return this.splitCardParent;
    }

    @Override
    public ManaCosts<ManaCost> getManaCost() {
        return this.manaCosts;
    }

    @Override
    public List<String> getManaCostSymbols() {
        return this.manaCostsSymbols;
    }
}

