/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.repository;

import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.Where;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mage.cards.repository.CardRepository;
import mage.constants.CardType;
import mage.constants.Rarity;
import mage.constants.SubType;
import mage.constants.SuperType;

public class CardCriteria {
    private String nameContains;
    private String name;
    private String rules;
    private final List<String> setCodes = new ArrayList<String>();
    private final List<String> ignoreSetCodes = new ArrayList<String>();
    private final List<CardType> types;
    private final List<CardType> notTypes;
    private final List<SuperType> supertypes;
    private final List<SuperType> notSupertypes;
    private final List<SubType> subtypes;
    private final List<Rarity> rarities = new ArrayList<Rarity>();
    private Boolean variousArt;
    private Boolean doubleFaced;
    private Boolean modalDoubleFaced;
    private Boolean nightCard = false;
    private boolean black = true;
    private boolean blue = true;
    private boolean green = true;
    private boolean red = true;
    private boolean white = true;
    private boolean colorless = true;
    private Integer manaValue;
    private String sortBy;
    private Long start;
    private Long count;
    private int minCardNumber;
    private int maxCardNumber;

    public CardCriteria() {
        this.types = new ArrayList<CardType>();
        this.notTypes = new ArrayList<CardType>();
        this.supertypes = new ArrayList<SuperType>();
        this.notSupertypes = new ArrayList<SuperType>();
        this.subtypes = new ArrayList<SubType>();
        this.minCardNumber = Integer.MIN_VALUE;
        this.maxCardNumber = Integer.MAX_VALUE;
    }

    public CardCriteria black(boolean black) {
        this.black = black;
        return this;
    }

    public CardCriteria blue(boolean blue) {
        this.blue = blue;
        return this;
    }

    public CardCriteria green(boolean green) {
        this.green = green;
        return this;
    }

    public CardCriteria red(boolean red) {
        this.red = red;
        return this;
    }

    public CardCriteria white(boolean white) {
        this.white = white;
        return this;
    }

    public CardCriteria colorless(boolean colorless) {
        this.colorless = colorless;
        return this;
    }

    public CardCriteria variousArt(boolean variousArt) {
        this.variousArt = variousArt;
        return this;
    }

    public CardCriteria doubleFaced(boolean doubleFaced) {
        this.doubleFaced = doubleFaced;
        return this;
    }

    public CardCriteria modalDoubleFaced(boolean modalDoubleFaced) {
        this.modalDoubleFaced = modalDoubleFaced;
        return this;
    }

    public CardCriteria nightCard(Boolean nightCard) {
        this.nightCard = nightCard;
        return this;
    }

    public CardCriteria nameContains(String str) {
        this.nameContains = str;
        return this;
    }

    public CardCriteria name(String name) {
        this.name = name;
        return this;
    }

    public CardCriteria rules(String rules) {
        this.rules = rules;
        return this;
    }

    public CardCriteria start(Long start) {
        this.start = start;
        return this;
    }

    public CardCriteria count(Long count) {
        this.count = count;
        return this;
    }

    public CardCriteria rarities(Rarity ... rarities) {
        this.rarities.addAll(Arrays.asList(rarities));
        return this;
    }

    public CardCriteria setCodes(String ... setCodes) {
        return this.setCodes(Arrays.asList(setCodes));
    }

    public CardCriteria setCodes(List<String> setCodes) {
        this.setCodes.addAll(setCodes);
        return this;
    }

    public CardCriteria ignoreSetCodes(String ... ignoreSetCodes) {
        this.ignoreSetCodes.addAll(Arrays.asList(ignoreSetCodes));
        return this;
    }

    public CardCriteria ignoreSetsWithSnowLands() {
        this.ignoreSetCodes.addAll(CardRepository.snowLandSetCodes);
        return this;
    }

    public CardCriteria types(CardType ... types) {
        this.types.addAll(Arrays.asList(types));
        return this;
    }

    public CardCriteria notTypes(CardType ... types) {
        this.notTypes.addAll(Arrays.asList(types));
        return this;
    }

    public CardCriteria supertypes(SuperType ... supertypes) {
        this.supertypes.addAll(Arrays.asList(supertypes));
        return this;
    }

    public CardCriteria notSupertypes(SuperType ... supertypes) {
        this.notSupertypes.addAll(Arrays.asList(supertypes));
        return this;
    }

    public CardCriteria subtypes(SubType ... subtypes) {
        this.subtypes.addAll(Arrays.asList(subtypes));
        return this;
    }

    public CardCriteria manaValue(Integer manaValue) {
        this.manaValue = manaValue;
        return this;
    }

    public CardCriteria minCardNumber(int minCardNumber) {
        this.minCardNumber = minCardNumber;
        return this;
    }

    public CardCriteria maxCardNumber(int maxCardNumber) {
        this.maxCardNumber = maxCardNumber;
        return this;
    }

    public CardCriteria setOrderBy(String sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public void buildQuery(QueryBuilder qb) throws SQLException {
        this.optimize();
        Where where = qb.where();
        int clausesCount = 0;
        if (this.nightCard != null) {
            where.eq("nightCard", (Object)this.nightCard);
            ++clausesCount;
        }
        where.eq("splitCardHalf", (Object)false);
        ++clausesCount;
        if (this.nameContains != null) {
            where.like("name", (Object)new SelectArg((Object)('%' + this.nameContains + '%')));
            ++clausesCount;
        }
        if (this.name != null) {
            where.eq("name", (Object)new SelectArg((Object)this.name));
            ++clausesCount;
        }
        if (this.rules != null) {
            where.like("rules", (Object)new SelectArg((Object)('%' + this.rules + '%')));
            ++clausesCount;
        }
        if (this.variousArt != null) {
            where.eq("variousArt", (Object)this.variousArt);
            ++clausesCount;
        }
        if (this.doubleFaced != null) {
            where.eq("doubleFaced", (Object)this.doubleFaced);
            ++clausesCount;
        }
        if (this.modalDoubleFaced != null) {
            where.eq("modalDoubleFacedCard", (Object)this.modalDoubleFaced);
            ++clausesCount;
        }
        for (Rarity rarity : this.rarities) {
            where.eq("rarity", (Object)rarity);
        }
        if (!this.rarities.isEmpty()) {
            where.or(this.rarities.size());
            ++clausesCount;
        }
        for (String setCode : this.setCodes) {
            where.eq("setCode", (Object)setCode);
        }
        if (!this.setCodes.isEmpty()) {
            where.or(this.setCodes.size());
            ++clausesCount;
        }
        for (String ignoreSetCode : this.ignoreSetCodes) {
            where.ne("setCode", (Object)ignoreSetCode);
        }
        if (!this.ignoreSetCodes.isEmpty()) {
            where.and(this.ignoreSetCodes.size());
            ++clausesCount;
        }
        if (this.types.size() != 7) {
            for (CardType type : this.types) {
                where.like("types", (Object)new SelectArg((Object)('%' + type.name() + '%')));
            }
            if (!this.types.isEmpty()) {
                where.or(this.types.size());
                ++clausesCount;
            }
        }
        for (CardType type : this.notTypes) {
            where.not().like("types", (Object)new SelectArg((Object)('%' + type.name() + '%')));
            ++clausesCount;
        }
        for (SuperType superType : this.supertypes) {
            where.like("supertypes", (Object)new SelectArg((Object)('%' + superType.name() + '%')));
            ++clausesCount;
        }
        for (SuperType superType : this.notSupertypes) {
            where.not().like("supertypes", (Object)new SelectArg((Object)('%' + superType.name() + '%')));
            ++clausesCount;
        }
        for (SubType subType : this.subtypes) {
            where.like("subtypes", (Object)new SelectArg((Object)('%' + subType.toString() + '%')));
            ++clausesCount;
        }
        if (this.manaValue != null) {
            where.eq("manaValue", (Object)this.manaValue);
            ++clausesCount;
        }
        int colorClauses = 0;
        if (this.black) {
            where.eq("black", (Object)true);
            ++colorClauses;
        }
        if (this.blue) {
            where.eq("blue", (Object)true);
            ++colorClauses;
        }
        if (this.green) {
            where.eq("green", (Object)true);
            ++colorClauses;
        }
        if (this.red) {
            where.eq("red", (Object)true);
            ++colorClauses;
        }
        if (this.white) {
            where.eq("white", (Object)true);
            ++colorClauses;
        }
        if (this.colorless) {
            where.eq("black", (Object)false).eq("blue", (Object)false).eq("green", (Object)false).eq("red", (Object)false).eq("white", (Object)false);
            where.and(5);
            ++colorClauses;
        }
        if (colorClauses > 0) {
            where.or(colorClauses);
            ++clausesCount;
        }
        if (this.minCardNumber != Integer.MIN_VALUE) {
            where.ge("cardNumberAsInt", (Object)this.minCardNumber);
            ++clausesCount;
        }
        if (this.maxCardNumber != Integer.MAX_VALUE) {
            where.le("cardNumberAsInt", (Object)this.maxCardNumber);
            ++clausesCount;
        }
        if (clausesCount > 0) {
            where.and(clausesCount);
        } else {
            where.eq("cardNumber", (Object)new SelectArg((Object)0));
        }
        if (this.start != null) {
            qb.offset(this.start);
        }
        if (this.count != null) {
            qb.limit(this.count);
        }
        if (this.sortBy != null) {
            qb.orderBy(this.sortBy, true);
        }
    }

    private CardCriteria optimize() {
        if (this.rarities.size() > 0) {
            ArrayList<Rarity> unusedRarities = new ArrayList<Rarity>(Arrays.asList(Rarity.values()));
            unusedRarities.removeAll(this.rarities);
            if (unusedRarities.isEmpty()) {
                this.rarities.clear();
            }
        }
        if (this.black && this.blue && this.green && this.red && this.white && this.colorless) {
            this.black = false;
            this.blue = false;
            this.green = false;
            this.red = false;
            this.white = false;
            this.colorless = false;
        }
        if (this.types.size() > 0) {
            ArrayList<CardType> unusedCardTypes = new ArrayList<CardType>(Arrays.asList(CardType.values()));
            unusedCardTypes.removeAll(this.types);
            if (unusedCardTypes.stream().noneMatch(CardType::isIncludeInSearch)) {
                this.types.clear();
            }
        }
        return this;
    }

    public String getNameContains() {
        return this.nameContains;
    }

    public String getName() {
        return this.name;
    }

    public String getRules() {
        return this.rules;
    }

    public List<String> getSetCodes() {
        return this.setCodes;
    }

    public List<String> getIgnoreSetCodes() {
        return this.ignoreSetCodes;
    }

    public List<CardType> getTypes() {
        return this.types;
    }

    public List<CardType> getNotTypes() {
        return this.notTypes;
    }

    public List<SuperType> getSupertypes() {
        return this.supertypes;
    }

    public List<SuperType> getNotSupertypes() {
        return this.notSupertypes;
    }

    public List<SubType> getSubtypes() {
        return this.subtypes;
    }

    public List<Rarity> getRarities() {
        return this.rarities;
    }

    public Boolean getVariousArt() {
        return this.variousArt;
    }

    public Boolean getDoubleFaced() {
        return this.doubleFaced;
    }

    public Boolean getModalDoubleFaced() {
        return this.modalDoubleFaced;
    }

    public boolean isBlack() {
        return this.black;
    }

    public boolean isBlue() {
        return this.blue;
    }

    public boolean isGreen() {
        return this.green;
    }

    public boolean isRed() {
        return this.red;
    }

    public boolean isWhite() {
        return this.white;
    }

    public boolean isColorless() {
        return this.colorless;
    }

    public Integer getManaValue() {
        return this.manaValue;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public Long getStart() {
        return this.start;
    }

    public Long getCount() {
        return this.count;
    }

    public int getMinCardNumber() {
        return this.minCardNumber;
    }

    public int getMaxCardNumber() {
        return this.maxCardNumber;
    }
}

