/*
 * Decompiled with CFR 0.152.
 */
package mage.choices;

import java.util.ArrayList;
import java.util.List;
import mage.MageObject;
import mage.Mana;
import mage.ObjectColor;
import mage.choices.ChoiceImpl;

public class ChoiceColor
extends ChoiceImpl {
    private static final List<String> colorChoices = ChoiceColor.getBaseColors();

    public static List<String> getBaseColors() {
        ArrayList<String> arr = new ArrayList<String>();
        arr.add("White");
        arr.add("Blue");
        arr.add("Black");
        arr.add("Red");
        arr.add("Green");
        return arr;
    }

    public ChoiceColor() {
        this(true);
    }

    public ChoiceColor(boolean required) {
        this(required, "Choose color");
    }

    public ChoiceColor(boolean required, String chooseMessage) {
        this(required, chooseMessage, "");
    }

    public ChoiceColor(boolean required, String chooseMessage, MageObject source) {
        this(required, chooseMessage, source.getIdName());
    }

    public ChoiceColor(boolean required, String chooseMessage, String chooseSubMessage) {
        super(required);
        this.choices.addAll(colorChoices);
        this.setMessage(chooseMessage);
        this.setSubMessage(chooseSubMessage);
        this.manaColorChoice = true;
    }

    protected ChoiceColor(ChoiceColor choice) {
        super(choice);
    }

    @Override
    public ChoiceColor copy() {
        return new ChoiceColor(this);
    }

    public void removeColorFromChoices(String colorName) {
        this.choices.remove(colorName);
    }

    public ObjectColor getColor() {
        return ChoiceColor.getColorFromString(this.choice);
    }

    public static ObjectColor getColorFromString(String colorString) {
        if (colorString == null) {
            return null;
        }
        ObjectColor color = new ObjectColor();
        switch (colorString) {
            case "Black": {
                color.setBlack(true);
                break;
            }
            case "Blue": {
                color.setBlue(true);
                break;
            }
            case "Green": {
                color.setGreen(true);
                break;
            }
            case "Red": {
                color.setRed(true);
                break;
            }
            case "White": {
                color.setWhite(true);
            }
        }
        return color;
    }

    public Mana getMana(int amount) {
        Mana mana = this.getColor().isBlack() ? Mana.BlackMana(amount) : (this.getColor().isBlue() ? Mana.BlueMana(amount) : (this.getColor().isRed() ? Mana.RedMana(amount) : (this.getColor().isGreen() ? Mana.GreenMana(amount) : (this.getColor().isWhite() ? Mana.WhiteMana(amount) : Mana.ColorlessMana(amount)))));
        return mana;
    }

    public void increaseMana(Mana mana) {
        if (this.getColor().isBlack()) {
            mana.increaseBlack();
        } else if (this.getColor().isBlue()) {
            mana.increaseBlue();
        } else if (this.getColor().isRed()) {
            mana.increaseRed();
        } else if (this.getColor().isGreen()) {
            mana.increaseGreen();
        } else if (this.getColor().isWhite()) {
            mana.increaseWhite();
        } else {
            mana.increaseColorless();
        }
    }
}

