/*
 * Decompiled with CFR 0.152.
 */
package mage.choices;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

public class ChooseFriendsAndFoes {
    private List<Player> friends = new ArrayList<Player>();
    private List<Player> foes = new ArrayList<Player>();

    public boolean chooseFriendOrFoe(Player playerChoosing, Ability source, Game game) {
        if (playerChoosing == null) {
            return false;
        }
        this.friends.clear();
        this.foes.clear();
        for (UUID playerId : game.getState().getPlayersInRange(playerChoosing.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            if (playerChoosing.chooseUse(Outcome.Vote, "Is " + player.getName() + " friend or foe?", null, "Friend", "Foe", source, game)) {
                this.friends.add(player);
                continue;
            }
            this.foes.add(player);
        }
        return true;
    }

    public List<Player> getFriends() {
        return this.friends;
    }

    public List<Player> getFoes() {
        return this.foes;
    }
}

