/*
 * Decompiled with CFR 0.152.
 */
package mage.choices;

import java.util.Optional;
import mage.abilities.Ability;
import mage.game.Game;
import mage.players.Player;

public abstract class VillainousChoice {
    private final String rule;
    private final String message;

    protected VillainousChoice(String rule, String message) {
        this.rule = rule;
        this.message = message;
    }

    public abstract boolean doChoice(Player var1, Game var2, Ability var3);

    public String getRule() {
        return this.rule;
    }

    public String getMessage(Game game, Ability source) {
        if (!this.message.contains("{controller}")) {
            return this.message;
        }
        String controllerName = Optional.ofNullable(game.getPlayer(source.getControllerId())).map(Player::getName).orElse("Opponent");
        return this.message.replace("{controller}", controllerName);
    }
}

