/*
 * Decompiled with CFR 0.152.
 */
package mage.constants;

public enum AbilityType {
    PLAY_LAND("Play land", true, false, false, false),
    SPELL("Spell", true, false, false, false),
    STATIC("Static", false, false, false, false),
    EVASION("Evasion", false, false, false, false),
    ACTIVATED_NONMANA("Activated", false, true, false, false),
    ACTIVATED_MANA("Mana", false, true, false, true),
    TRIGGERED_NONMANA("Triggered", false, false, true, false),
    TRIGGERED_MANA("Triggered Mana", false, false, true, true),
    SPECIAL_ACTION("Special Action", false, false, false, false),
    SPECIAL_MANA_PAYMENT("Special Mana Payment", false, false, false, false);

    private final String text;
    private final boolean playCardAbility;
    private final boolean activatedAbility;
    private final boolean triggeredAbility;
    private final boolean manaAbility;

    private AbilityType(String text, boolean playCardAbility, boolean activatedAbility, boolean triggeredAbility, boolean manaAbility) {
        this.text = text;
        this.playCardAbility = playCardAbility;
        this.activatedAbility = activatedAbility;
        this.triggeredAbility = triggeredAbility;
        this.manaAbility = manaAbility;
    }

    public String toString() {
        return this.text;
    }

    public boolean isPlayCardAbility() {
        return this.playCardAbility;
    }

    public boolean isActivatedAbility() {
        return this.activatedAbility;
    }

    public boolean isTriggeredAbility() {
        return this.triggeredAbility;
    }

    public boolean isNonManaActivatedAbility() {
        return this.activatedAbility && !this.manaAbility;
    }

    public boolean isManaActivatedAbility() {
        return this.activatedAbility && this.manaAbility;
    }

    public boolean isManaAbility() {
        return this.manaAbility;
    }
}

