/*
 * Decompiled with CFR 0.152.
 */
package mage.constants;

import java.util.ArrayList;
import java.util.Arrays;
import mage.MageObject;
import mage.filter.predicate.Predicate;
import mage.game.Game;

public enum CardType {
    ARTIFACT("Artifact", true, true),
    BATTLE("Battle", true, true),
    CONSPIRACY("Conspiracy", false, false),
    CREATURE("Creature", true, true),
    DUNGEON("Dungeon", false, false),
    ENCHANTMENT("Enchantment", true, true),
    INSTANT("Instant", false, true),
    LAND("Land", true, true),
    PHENOMENON("Phenomenon", false, false),
    PLANE("Plane", false, false),
    PLANESWALKER("Planeswalker", true, true),
    SCHEME("Scheme", false, false),
    SORCERY("Sorcery", false, true),
    KINDRED("Kindred", false, false),
    VANGUARD("Vanguard", false, false);

    private final String text;
    private final boolean permanentType;
    private final boolean includeInSearch;
    private final CardTypePredicate predicate;

    private CardType(String text, boolean permanentType, boolean includeInSearch) {
        this.text = text;
        this.permanentType = permanentType;
        this.includeInSearch = includeInSearch;
        this.predicate = new CardTypePredicate(this);
    }

    public String toString() {
        return this.text;
    }

    public String getPluralName() {
        return this.text.endsWith("y") ? this.text.substring(0, this.text.length() - 1) + "ies" : this.text + 's';
    }

    public static CardType fromString(String value) {
        for (CardType ct : CardType.values()) {
            if (!ct.toString().equals(value)) continue;
            return ct;
        }
        throw new IllegalArgumentException("Can't find card type enum value: " + value);
    }

    public boolean isPermanentType() {
        return this.permanentType;
    }

    public boolean isIncludeInSearch() {
        return this.includeInSearch;
    }

    public static CardType[] mergeTypes(CardType[] a, CardType[] b) {
        ArrayList<CardType> cardTypes = new ArrayList<CardType>();
        cardTypes.addAll(Arrays.asList(a));
        cardTypes.addAll(Arrays.asList(b));
        return cardTypes.toArray(new CardType[0]);
    }

    public CardTypePredicate getPredicate() {
        return this.predicate;
    }

    public static class CardTypePredicate
    implements Predicate<MageObject> {
        private final CardType cardType;

        private CardTypePredicate(CardType cardType) {
            this.cardType = cardType;
        }

        @Override
        public boolean apply(MageObject input, Game game) {
            return input.getCardType(game).contains((Object)this.cardType);
        }

        public String toString() {
            return "CardType(" + this.cardType.toString() + ')';
        }
    }
}

