/*
 * Decompiled with CFR 0.152.
 */
package mage.constants;

public enum ComparisonType {
    FEWER_THAN("<"),
    OR_LESS("<="),
    EQUAL_TO("=="),
    MORE_THAN(">"),
    OR_GREATER(">=");

    final String operator;

    private ComparisonType(String op) {
        this.operator = op;
    }

    public String toString() {
        return this.operator;
    }

    public static boolean compare(int source, ComparisonType comparison, int target) {
        switch (comparison) {
            case MORE_THAN: {
                return source > target;
            }
            case FEWER_THAN: {
                return source < target;
            }
            case EQUAL_TO: {
                return source == target;
            }
            case OR_GREATER: {
                return source >= target;
            }
            case OR_LESS: {
                return source <= target;
            }
        }
        throw new IllegalArgumentException("comparison rules for " + (Object)((Object)comparison) + " missing");
    }
}

