/*
 * Decompiled with CFR 0.152.
 */
package mage.constants;

import mage.abilities.SpellAbility;
import mage.abilities.effects.common.continuous.BecomesFaceDownCreatureEffect;
import mage.abilities.keyword.BestowAbility;
import mage.abilities.keyword.PrototypeAbility;
import mage.cards.Card;
import mage.game.Game;
import mage.game.stack.Spell;

public enum SpellAbilityCastMode {
    NORMAL("Normal"),
    MADNESS("Madness"),
    FLASHBACK("Flashback"),
    HARMONIZE("Harmonize"),
    BESTOW("Bestow"),
    PROTOTYPE("Prototype"),
    MORPH("Morph", false, true),
    DISGUISE("Disguise", false, true),
    TRANSFORMED("Transformed", true),
    DISTURB("Disturb", true),
    MORE_THAN_MEETS_THE_EYE("More than Meets the Eye", true),
    PLOT("Plot");

    private final String text;
    private final boolean isTransformed;
    private final boolean isFaceDown;

    public boolean isTransformed() {
        return this.isTransformed;
    }

    private SpellAbilityCastMode(String text) {
        this(text, false);
    }

    private SpellAbilityCastMode(String text, boolean isTransformed) {
        this(text, isTransformed, false);
    }

    private SpellAbilityCastMode(String text, boolean isTransformed, boolean isFaceDown) {
        this.text = text;
        this.isTransformed = isTransformed;
        this.isFaceDown = isFaceDown;
    }

    public boolean isFaceDown() {
        return this.isFaceDown;
    }

    public String toString() {
        return this.text;
    }

    public Card getTypeModifiedCardObjectCopy(Card card, SpellAbility spellAbility, Game game) {
        Card tmp;
        Card cardCopy = card.copy();
        if (this.isTransformed && (tmp = card.getSecondCardFace()) != null) {
            cardCopy = tmp.copy();
        }
        switch (this) {
            case BESTOW: {
                BestowAbility.becomeAura(cardCopy);
                break;
            }
            case PROTOTYPE: {
                cardCopy = ((PrototypeAbility)spellAbility).prototypeCardSpell(cardCopy);
                break;
            }
            case MORPH: 
            case DISGUISE: {
                if (cardCopy instanceof Spell) {
                    cardCopy = ((Spell)cardCopy).getCard().copy();
                }
                BecomesFaceDownCreatureEffect.FaceDownType faceDownType = BecomesFaceDownCreatureEffect.FaceDownType.MORPHED;
                if (this == DISGUISE) {
                    faceDownType = BecomesFaceDownCreatureEffect.FaceDownType.DISGUISED;
                }
                BecomesFaceDownCreatureEffect.makeFaceDownObject(game, null, cardCopy, faceDownType, null);
                break;
            }
            case NORMAL: 
            case MADNESS: 
            case FLASHBACK: 
            case HARMONIZE: 
            case DISTURB: 
            case PLOT: 
            case MORE_THAN_MEETS_THE_EYE: {
                break;
            }
            case TRANSFORMED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Un-supported ability cast mode: " + (Object)((Object)this));
            }
        }
        return cardCopy;
    }
}

