/*
 * Decompiled with CFR 0.152.
 */
package mage.constants;

import mage.MageObject;
import mage.filter.predicate.Predicate;
import mage.game.Game;

public enum SuperType {
    BASIC("Basic"),
    ELITE("Elite"),
    LEGENDARY("Legendary"),
    ONGOING("Ongoing"),
    SNOW("Snow"),
    WORLD("World");

    private final String text;
    private final SuperTypePredicate predicate;

    private SuperType(String text) {
        this.text = text;
        this.predicate = new SuperTypePredicate(this);
    }

    public String toString() {
        return this.text;
    }

    public SuperTypePredicate getPredicate() {
        return this.predicate;
    }

    public static class SuperTypePredicate
    implements Predicate<MageObject> {
        private final SuperType supertype;

        private SuperTypePredicate(SuperType supertype) {
            this.supertype = supertype;
        }

        @Override
        public boolean apply(MageObject input, Game game) {
            return input.getSuperType(game).contains((Object)this.supertype);
        }

        public String toString() {
            return "Supertype(" + (Object)((Object)this.supertype) + ')';
        }
    }
}

