/*
 * Decompiled with CFR 0.152.
 */
package mage.designations;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.hint.common.CurrentDungeonHint;
import mage.constants.Zone;
import mage.designations.InitiativeUndercityEffect;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;

class InitiativeVentureTriggeredAbility
extends TriggeredAbilityImpl {
    InitiativeVentureTriggeredAbility() {
        super(Zone.ALL, new InitiativeUndercityEffect());
        this.addHint(CurrentDungeonHint.instance);
    }

    private InitiativeVentureTriggeredAbility(InitiativeVentureTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public InitiativeVentureTriggeredAbility copy() {
        return new InitiativeVentureTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE || event.getType() == GameEvent.EventType.TOOK_INITIATIVE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        UUID playerId;
        switch (event.getType()) {
            case UPKEEP_STEP_PRE: {
                if (!game.isActivePlayer(game.getInitiativeId())) {
                    return false;
                }
                playerId = game.getActivePlayerId();
                break;
            }
            case TOOK_INITIATIVE: {
                playerId = event.getPlayerId();
                break;
            }
            default: {
                return false;
            }
        }
        this.getEffects().setTargetPointer(new FixedTarget(playerId));
        return true;
    }

    @Override
    public String getRule() {
        return "Whenever you take the initiative and at the beginning of your upkeep, venture into Undercity.";
    }
}

